:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "24"
:setvar DeployVersion "20150223.1"

SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;
GO

:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END
GO

PRINT 'Step 3 - Registry.Database.PostDeploy.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO
  

USE [$(DatabaseName)]
GO

PRINT 'Insert Data using script Load_AHOBPR_STD_TABLES.sql...';
GO


GO
PRINT 'Load_AHOBPR_STD_TABLES.sql started...';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
GO

SET IDENTITY_INSERT [AHOBPR].[STD_PROCESS_METRICS_TYPE] ON
IF NOT EXISTS (SELECT * FROM [AHOBPR].[STD_PROCESS_METRICS_TYPE] WHERE [PROCESS_METRICS] =  N'Registrant Status Change')
  INSERT 
    INTO  [AHOBPR].[STD_PROCESS_METRICS_TYPE] ([STD_PROCESS_METRICS_TYPE_ID], [PROCESS_METRICS], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
    VALUES (1, N'Registrant Status Change', N'DBA', N'DBA', CAST(0x0000000060390B0000 AS DateTime2), CAST(0x0000000060390B0000 AS DateTime2));

SET IDENTITY_INSERT [AHOBPR].[STD_PROCESS_METRICS_TYPE] OFF

PRINT 'Merging data for [AHOBPR].[STD_REGISTRANT_STATUS]...'; 
GO

DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               ('No Consent',1),
               ('Consent',2),
               ('Not Eligible',3),
               ('Review',4),
               ('Review - Not Eligible',5),
               ('Eligible', 6),
               ('Participant',7))
       AS MasterRecord(STATUS, OrdinalValue)
       )
MERGE
  INTO  [AHOBPR].[STD_REGISTRANT_STATUS] AS Tgt
  USING MasterData AS Src
  ON    Tgt.REGISTRANT_STATUS = Src.STATUS
 WHEN  NOT MATCHED
 THEN  INSERT
        ([REGISTRANT_STATUS], ORDINAL_VALUE, [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
        VALUES
        (Src.STATUS, Src.OrdinalValue, @UserName, @UserName, @Today,@Today)
;     
GO

PRINT 'Merging data for [AHOBPR].[STD_SERVICE_STATUS]...'; 
GO

DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               ('Veteran'),
               ('Active Duty'),
               ('Retiree'))
       AS MasterRecord(STATUS)
       )
MERGE
  INTO  [AHOBPR].[STD_SERVICE_STATUS] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[SERVICE_STATUS] = Src.STATUS
  WHEN  MATCHED
  THEN  UPDATE
        SET [SERVICE_STATUS] = Src.STATUS,
            UPDATEDBY = @UserName,   
            UPDATED = @Today
 WHEN  NOT MATCHED
 THEN  INSERT
        ([SERVICE_STATUS], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
        VALUES
        (Src.STATUS, @UserName, @UserName, @Today,@Today)
;            
GO

PRINT 'Merging data for [AHOBPR].[STD_DEPLOYMENT_LOCATION]...'; 
GO

IF NOT EXISTS(SELECT * FROM  [AHOBPR].[STD_DEPLOYMENT_LOCATION])
BEGIN
DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();
WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
                ('none','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('87 PB','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('00_PB','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('2 (2-8)','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('2 TCP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('302','Afghanistan','afgan afgahn aghan afhan','OP 302','Helmand'),
                ('4 Corners','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('4 TCP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('5_OP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('5th ABP Compound','Afghanistan','afgan afgahn aghan afhan','5TH ABP','Paktika'),
                ('7171','Afghanistan','afgan afgahn aghan afhan','PB 7171','Helmand'),
                ('92 PB','Afghanistan','afgan afgahn aghan afhan','Banadar','Helmand'),
                ('95_OP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('ABP HQ','Afghanistan','afgan afgahn aghan afhan','Gam Ser','Helmand'),
                ('ACS-2','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('ANP Hill','Afghanistan','afgan afgahn aghan afhan','OP Hil','Helmand'),
                ('ANP Hill','Afghanistan','afgan afgahn aghan afhan','','Maiwand'),
                ('ANP Station','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('AP Haji Ramuddin II','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('AP Kolk','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('AP Makuan','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('AP Pa''in Kelay','Afghanistan','afgan afgahn aghan afhan','','maiwand'),
                ('Ab Band','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Achabeti','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Active burn pits','Afghanistan','afgan afgahn aghan afhan','',''),
                ('Adraskan','Afghanistan','afgan afgahn aghan afhan','','Herat'),
                ('Ahman Khan AP','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Ainsworth','Afghanistan','afgan afgahn aghan afhan','Emarat','Kandahar'),
                ('Airborne','Afghanistan','afgan afgahn aghan afhan','Camp Airborne','Wardak'),
                ('Al Maasak','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Alamo_PB','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Alcatraz','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Alizi','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Almas','Afghanistan','afgan afgahn aghan afhan','PB Almas','Helmand'),
                ('Altoona','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Amboy','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Amir Agha','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Amir','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Amoo','Afghanistan','afgan afgahn aghan afhan','PB Amoo','Helmand'),
                ('Ape Marcie','Afghanistan','afgan afgahn aghan afhan','PB Ape-Marcie','Helmand'),
                ('Arghandab DCP','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Arghandab OCCB','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Arian','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Aries 2','Afghanistan','afgan afgahn aghan afhan','PB Aries 2','Helmand'),
                ('Ashoque','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Atal Yak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Atal','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Athens','Afghanistan','afgan afgahn aghan afhan','OP Athens','Helmand'),
                ('Atlantic City','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Azimijan Kariz AP','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Aziz Ullah','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Aziz','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('BAK DC','Afghanistan','afgan afgahn aghan afhan','BAK','Khowst'),
                ('Babaghday','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Bad Pakh','Afghanistan','afgan afgahn aghan afhan','','Laghman'),
                ('Badger','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Baghtu','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Bagram','Afghanistan','afgan afgahn aghan afhan','BAF','Parwan'),
                ('Bakhar','Afghanistan','afgan afgahn aghan afhan','PB Bakhar','Helmand'),
                ('Banadar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Bande Sarde','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Bandini','Afghanistan','afgan afgahn aghan afhan','PB Bandini','Helmand'),
                ('Barcha','Afghanistan','afgan afgahn aghan afhan','PB Barcha','Helmand'),
                ('Bariolai','Afghanistan','afgan afgahn aghan afhan','OP Bariolai','Helmand'),
                ('Barrows','Afghanistan','afgan afgahn aghan afhan','PB Barrows','Helmand'),
                ('Basha','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Baylough','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Beatley','Afghanistan','afgan afgahn aghan afhan','PB Beatley','Helmand'),
                ('Beirut','Afghanistan','afgan afgahn aghan afhan','PB Beirut','Helmand'),
                ('Bishop','Afghanistan','afgan afgahn aghan afhan','PB Bishop','Helmand'),
                ('Blackbird','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Blue OP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Boldak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Boris','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Bostick','Afghanistan','afgan afgahn aghan afhan','FOB Naray','Kunar'),
                ('Bouresches','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Bowri Tanah Ap','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Bowri Tanah','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Bridge 3','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Bullard','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Bulldog','Afghanistan','afgan afgahn aghan afhan','','Nangarhar'),
                ('Buman Demil','Afghanistan','afgan afgahn aghan afhan','Dorafshan',' Tarin Kowt'),
                ('Burmohammad','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Bury','Afghanistan','afgan afgahn aghan afhan','PB Bury','Helmand'),
                ('CP 11','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('CP 2.5','Afghanistan','afgan afgahn aghan afhan','Checkpoint 2.5','Kunar'),
                ('CP 4','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('CP 7-4','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('CP 72','Afghanistan','afgan afgahn aghan afhan','Nawa Valley','Kandahar'),
                ('CP-1','Afghanistan','afgan afgahn aghan afhan','Checkpoint 1','Helmand'),
                ('Camden','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Camel','Afghanistan','afgan afgahn aghan afhan','PB Camel','Helmand'),
                ('Carolina','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Cemetary Tower','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Center','Afghanistan','afgan afgahn aghan afhan','PB Center','Helmand'),
                ('Chak DC','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Chakaw','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Chamkani','Afghanistan','afgan afgahn aghan afhan','','Paktya'),
                ('Chergotah','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Chosin','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Comanche','Afghanistan','afgan afgahn aghan afhan','JCOP Sherzad','Nangarhar'),
                ('Compton','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Coutu','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Cowboy','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Criss','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Cuba','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Curry','Afghanistan','afgan afgahn aghan afhan','Gomal',' Bandar'),
                ('Dakota','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Daman Distric HQs','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Dand Patan','Afghanistan','afgan afgahn aghan afhan','Camp Dand Patan','Pakitya'),
                ('Dangar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Darvishan KHK District','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Darvishan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dasht','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dashtu','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Daytona','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('De Young','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Deh Dadi I','Afghanistan','afgan afgahn aghan afhan','','Balkh'),
                ('Deh Karez','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Deh Qobad','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Deh Qobad','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Dehanna Pass','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dehemozong','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dehli Police HQ','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dehli','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Delaram DC','Afghanistan','afgan afgahn aghan afhan','Delaram District Center','Nimorz'),
                ('Delaram I','Afghanistan','afgan afgahn aghan afhan','Delaram 1','Nimorz'),
                ('Delaram II','Afghanistan','afgan afgahn aghan afhan','Delaram 2','Nimorz'),
                ('Deleram AUP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Delmar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Delorean','Afghanistan','afgan afgahn aghan afhan','Camp Delorean','Unkown'),
                ('Demaiwand AP','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Demaiwand','Afghanistan','afgan afgahn aghan afhan','','Maiwand'),
                ('Detroit','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Deysie','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Didgori','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Divlak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Diwar','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Donahue','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Doost','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dre Wazaran','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dukin','Afghanistan','afgan afgahn aghan afhan','','Farah'),
                ('Duluth','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Durani','Afghanistan','afgan afgahn aghan afhan','Camp Durani','Wardak'),
                ('Durzay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Dwyer','Afghanistan','afgan afgahn aghan afhan','Camp Dwyer','Helmand'),
                ('EBK','Afghanistan','afgan afgahn aghan afhan','Ebrahem Kheyl','Logar'),
                ('Edinburgh','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Eiffel','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Empire','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Enguri','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Ensenada','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Eredvi','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Ertoba','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Faheem','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Faizal','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Faslodeen','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Fathollah','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Fern Gulley','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Fiddlers Greeen','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Fires','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Flint Kaserne','Afghanistan','afgan afgahn aghan afhan','','Nangarhar'),
                ('Florida','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Folad','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Frontenac','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Garbuz','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Garcia','Afghanistan','afgan afgahn aghan afhan','','Nangarhar'),
                ('Garda','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Gardez RTC','Afghanistan','afgan afgahn aghan afhan','RTC Gardez','Paktiya'),
                ('Gardez','Afghanistan','afgan afgahn aghan afhan','','Paktiya'),
                ('Garrett','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gators','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Georgetown','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Georgia','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gereshk','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Geronimo','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gettysburgh','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Ghariban','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Ghazni','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Ghundy Ghar','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Ghundy Ghar','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Giro','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Glavey','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gorgan','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Gowragi','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Grand  Rapids','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Greer','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Griffin','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Grosse Point','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gumbatty Tower','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Gumbatty','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Habib','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hadrian','Afghanistan','afgan afgahn aghan afhan','','Urzugan'),
                ('Haji Achmed','Afghanistan','afgan afgahn aghan afhan','OP Haji Achmed','Helmand'),
                ('Haji Achmed','Afghanistan','afgan afgahn aghan afhan','PB Haji Achmed','Helmand'),
                ('Haji Alilua','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Haji Nizmadeen','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Haji Ramuddin II','Afghanistan','afgan afgahn aghan afhan','Haji Ramuddin 2','Kandahar'),
                ('Haji Ramuddin','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Hand','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hanjar Do','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hanjar Yak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hanjar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hanson','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Harris','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Hasan Abad','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Herm','Afghanistan','afgan afgahn aghan afhan','Weikel',' Yaka Tut'),
                ('Hernandez','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Herrera','Afghanistan','afgan afgahn aghan afhan','','Jaji'),
                ('Hill','Afghanistan','afgan afgahn aghan afhan','OP Hill','Helmand'),
                ('Himal','Afghanistan','afgan afgahn aghan afhan','','Schaepe'),
                ('Honaker-Miracle','Afghanistan','afgan afgahn aghan afhan','','Kunar'),
                ('Honeycutt','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Howz-E-Madad','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Hue City','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Husey','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Huskers (SW)','Afghanistan','afgan afgahn aghan afhan','Huskers','Helmand'),
                ('Imam Sahib (S)','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Inchon','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Infante','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Inkerman','Afghanistan','afgan afgahn aghan afhan','Samsher','Helmand'),
                ('Jaghato','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Jaker','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Jalrez','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Jangealia','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Januup','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Jawkari','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Jersey','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Johnson','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Johnston','Afghanistan','afgan afgahn aghan afhan','CP 13-2','Kandahar'),
                ('Judge','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Jug Room','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('KKC Super FOB','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('KT-4','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kabob','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kadalo Drab','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kakaran','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Kalagush','Afghanistan','afgan afgahn aghan afhan','','Nuristan'),
                ('Kandahar AF','Afghanistan','afgan afgahn aghan afhan','',''),
                ('Kandalay','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Karimdad','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Kdle','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kelly','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kems','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kessler','Afghanistan','afgan afgahn aghan afhan','Sarkari Bagh','Kandahar'),
                ('Khak-E Safed','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Khalil','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Khan Neshin Castle','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Khayor Khot Castle','Afghanistan','afgan afgahn aghan afhan','KKC','Paktika'),
                ('Khers','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kherwar','Afghanistan','afgan afgahn aghan afhan','','Logar'),
                ('Kheyrabad','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Khiyal  Zmeka','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Khojibad','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Khyber','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Kimmel','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kochynay Prong','Afghanistan','afgan afgahn aghan afhan','','Nawa'),
                ('Kolk','Afghanistan','afgan afgahn aghan afhan','Camp Kolk','Zharay'),
                ('Kordala Drap','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kostay CP','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kostay PB','Afghanistan','afgan afgahn aghan afhan','COP Koshtay','Helmand'),
                ('Kowall','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Kuhak','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Kuhl','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kunjak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kunjik','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Kupak','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Kushamond','Afghanistan','afgan afgahn aghan afhan','Pacemaker','Paktika'),
                ('Lagman','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Lakaray','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Lakeside','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lakhokhel','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Laki','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lam','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Lamba Dand','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lambert','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Landay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lane','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Lashkar Gar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Leatherneck','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Leimbach','Afghanistan','afgan afgahn aghan afhan','','Farah'),
                ('Levy','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lion','Afghanistan','afgan afgahn aghan afhan','','Panjshir'),
                ('Long beach','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Lowell','Afghanistan','afgan afgahn aghan afhan','','Nuristan'),
                ('Luke','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Luy Jolah','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Luy Kulay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Luy Tsolar','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Maboob','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Mace','Afghanistan','afgan afgahn aghan afhan','','Konar'),
                ('Macthab','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Mahafiz','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Maher','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Makuan','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Manassas','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Margah','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Marjah','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Marler','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Maryland','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Masaw','Afghanistan','afgan afgahn aghan afhan','JCOP Masaw','Unkown'),
                ('Mashal','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Masood','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Mata Khan','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Mateen Yak','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Mateen','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Matun Hill','Afghanistan','afgan afgahn aghan afhan','OCC-P','Khowst'),
                ('May','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Maywand','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('McElhaney','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Mehraj','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Meis','Afghanistan','afgan afgahn aghan afhan','Ward','Helmand'),
                ('Michigan','Afghanistan','afgan afgahn aghan afhan','','Kunar'),
                ('Miri','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Mizan','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Momenkhan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Monar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Monitor','Afghanistan','afgan afgahn aghan afhan','','Jowzjan'),
                ('Montana','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Monti','Afghanistan','afgan afgahn aghan afhan','','Konar'),
                ('Moose','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Morales-Frazier','Afghanistan','afgan afgahn aghan afhan','','Kapisa'),
                ('Mubarez','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Muller','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Munoz','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Musa Qal''ah','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Musazai','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Mushan','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Mustang','Afghanistan','afgan afgahn aghan afhan','','Kunar'),
                ('Najil','Afghanistan','afgan afgahn aghan afhan','Najeel','Laghman'),
                ('Nalgham','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Nangalam Base','Afghanistan','afgan afgahn aghan afhan','Nangalam','Kunar'),
                ('Narizah','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Nejat','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Nerkh','Afghanistan','afgan afgahn aghan afhan','Blackhawk','Wardak'),
                ('New Jersey','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('New York','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Nolay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Nolen','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Normandy','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('North','Afghanistan','afgan afgahn aghan afhan','North PB','Helmand'),
                ('Norzai','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Now Ruzi','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Now Zad','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 102','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 20','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 22','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 288 Over watch','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 288','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 34','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 37','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 40','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP 41','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('OP-971','Afghanistan','afgan afgahn aghan afhan','Oqab','Kandahar'),
                ('Old PHQ','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Orbi','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Orgun-E','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Ouelette','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('PB 13','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('PB 19','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('PB 6','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('PB 7','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('PSS-3','Afghanistan','afgan afgahn aghan afhan','Police Substation 3','Kandahar'),
                ('PSS-7','Afghanistan','afgan afgahn aghan afhan','Police Substation 7','Kandahar'),
                ('Pa''in Kelay','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Pace','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Pacemaker','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Padlek','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Palace','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Palacio','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Panda Ridge','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pasaw','Afghanistan','afgan afgahn aghan afhan','','Farah'),
                ('Paserlay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pashmul South AP','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Pashmul South','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Pay Banadar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Paygal','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Payne','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pending closure or transfer','Afghanistan','afgan afgahn aghan afhan','',''),
                ('Penich','Afghanistan','afgan afgahn aghan afhan','','Kunar'),
                ('Pennsylvania','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pickard','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pinjadoo','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Pirtle King','Afghanistan','afgan afgahn aghan afhan','','Konar'),
                ('Pittman','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Pleiku','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Price','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Prov.Res. QRF','Afghanistan','afgan afgahn aghan afhan','Provincial Reserve','Kandahar'),
                ('Pul a Sayad','Afghanistan','afgan afgahn aghan afhan','Pul-a-Sayad','Parwan'),
                ('Pul','Afghanistan','afgan afgahn aghan afhan','Pul','Kandahar'),
                ('Push Tebah','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Pusht-e Rod','Afghanistan','afgan afgahn aghan afhan','PRDC','Farah'),
                ('Pushtaysark','Afghanistan','afgan afgahn aghan afhan','','Parwan'),
                ('Qal e Naw','Afghanistan','afgan afgahn aghan afhan','Camp Qal''eh-ye naw','Badghis'),
                ('Qal e Now PB','Afghanistan','afgan afgahn aghan afhan','Qal e Now','Helmand'),
                ('Qarabagh DC','Afghanistan','afgan afgahn aghan afhan','Pace','Ghazni'),
                ('Qargha','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Qarib','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Qual-I Now OP','Afghanistan','afgan afgahn aghan afhan','Qual-I Now (GBOSS)','Helmand'),
                ('Quara Baugh','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Qurta','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Rahman Kheyl','Afghanistan','afgan afgahn aghan afhan','','Paktiya'),
                ('Rankel','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Rashay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Reading','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Red Leg','Afghanistan','afgan afgahn aghan afhan','COP Red Leg','Unkown'),
                ('Regi Topa','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Reilly','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Ricketts','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Roadhouse','Afghanistan','afgan afgahn aghan afhan','','Logar'),
                ('Robat Sangi','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Robinson','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Rogers','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Rostum','Afghanistan','afgan afgahn aghan afhan','Mountain Top','Zharay'),
                ('Ruhd','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('SRE Kala','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sabari','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Sabit Qadam','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sabulughay','Afghanistan','afgan afgahn aghan afhan','',''),
                ('Saburi','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sacramento','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Saenz','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Saiedabdulkhalil','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Saipan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sakari Karez','Afghanistan','afgan afgahn aghan afhan','Ramrod',' Maiwand'),
                ('Salaam Bazaar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Salerno','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Salim','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Salor Lara','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('San Jose','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sanchez','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Sangin Badar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sangin Fulod','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sangsar','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Savannah','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Schoolhouse','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Seattle','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Senjaray','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Sham Shad','Afghanistan','afgan afgahn aghan afhan','Shamshad','Helmand'),
                ('Shamalan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Shamsher Char','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Shamsher Sey','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Shanfield','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sharana','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Sharkstooth','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sharp','Afghanistan','afgan afgahn aghan afhan','MIAN Poshtay','Helmand'),
                ('Sheklay Kahor','Afghanistan','afgan afgahn aghan afhan','Sheklay Kahor','Helmand'),
                ('Shewan Garrison','Afghanistan','afgan afgahn aghan afhan','Camp Shewan Garrison','Farah'),
                ('Shindand','Afghanistan','afgan afgahn aghan afhan','Thomas','Herat'),
                ('Shir Ghazay','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Shoja','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Shouz','Afghanistan','afgan afgahn aghan afhan','','Herat'),
                ('Shrine','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Shukvani','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sian Choy AP','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Sian Choy','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Simmons','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Smart','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Sockalosky','Afghanistan','afgan afgahn aghan afhan','PB Ben',' Ben'),
                ('Sofla','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sopar Dostan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('South Boston','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('South Station','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sparrow Hawk East','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sparrow Hawk West','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Spera','Afghanistan','afgan afgahn aghan afhan','','Unkown'),
                ('Sperwan Ghar','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Spin Ghar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Stansbury','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Styx','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sultan Kheyl','Afghanistan','afgan afgahn aghan afhan','Carwile',' Sol Tankhel'),
                ('Summerville','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Sweeney','Afghanistan','afgan afgahn aghan afhan','','Zabul'),
                ('Taber','Afghanistan','afgan afgahn aghan afhan','','Uruzgan'),
                ('Tabilia','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Tagab','Afghanistan','afgan afgahn aghan afhan','','Kapisa'),
                ('Taghaz','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Talibjan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Talukan','Afghanistan','afgan afgahn aghan afhan','Robinson','Kandahar'),
                ('Tangi','Afghanistan','afgan afgahn aghan afhan','','Wardak'),
                ('Tar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Tarin Kowt','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Tarnak','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Terezayi','Afghanistan','afgan afgahn aghan afhan','','Khowst'),
                ('Theinhart','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Tijuana','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Tillman','Afghanistan','afgan afgahn aghan afhan','Lawara','Paktika'),
                ('Timothy Johnson','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Togueh Substation','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Toor Ghar','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Torbert','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Torkham','Afghanistan','afgan afgahn aghan afhan','','Nangarhar'),
                ('Transformer','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Troy','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Tuffin','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Turbett','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Tynes','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Typhoon 3','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Typhoon 4','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Typhoon 5','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Unknown Location - Further research required.','Afghanistan','afgan afgahn aghan afhan','',''),
                ('Usman','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('VHA','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Vegas','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Virginia','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wakil Wazir','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Walakan','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Wali','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Walton','Afghanistan','afgan afgahn aghan afhan','','Uruzgan'),
                ('Ware','Afghanistan','afgan afgahn aghan afhan','Char Bagh','Kandahar'),
                ('Warrior','Afghanistan','afgan afgahn aghan afhan','','Ghazni'),
                ('Watson','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wazi Khwa','Afghanistan','afgan afgahn aghan afhan','Charlie 77','Paktika'),
                ('Weaver','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('West Bridge','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('White 10','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('White','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Whitehouse','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wilderness','Afghanistan','afgan afgahn aghan afhan','Tellier','Paktiya'),
                ('Wilson                (SW)','Afghanistan','afgan afgahn aghan afhan','Wilson','Helmand'),
                ('Wishtan','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wolfpack','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wolverine','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Wood','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Wrightsmen','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Yahya Kheyl','Afghanistan','afgan afgahn aghan afhan','','Paktika'),
                ('Yazzie','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Yosef Kheyl','Afghanistan','afgan afgahn aghan afhan','Camp Yosef Kheyl','Paktika'),
                ('Zaehringer','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Zangabad','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Zeebrugee','Afghanistan','afgan afgahn aghan afhan','','Helmand'),
                ('Zerok','Afghanistan','afgan afgahn aghan afhan','Camp Zerok','Paktika'),
                ('Zhari Dasht','Afghanistan','afgan afgahn aghan afhan','','Zharay'),
                ('Zharif Kel','Afghanistan','afgan afgahn aghan afhan','','Kandahar'),
                ('Zormat','Afghanistan','afgan afgahn aghan afhan','','Paktiya'),
                ('none','Arabian Sea','arabain arbian aribian arabien aravian carabian carrabien','6R',''),
                ('none','Bahrain','bahrian haharain bahrin bharain bharin bahrein bahri','BA',''),
                ('none','Djibouti','djbouti djibout Horn of Africa','DJ (HOA)',''),
                ('none','Gulf of Aden','adn adien adem adens adin adan anden','6D',''),
                ('none','Gulf of Oman','omani omni topman oma mani goman','6M',''),
                ('','Iraq','irak irag irac iraw','',''),
                ('308','Iraq','irak irag irac iraw','Apache, Gunner Main',''),
                ('ADL','Iraq','irak irag irac iraw','None',''),
                ('AR AR','Iraq','irak irag irac iraw','Broomhead',''),
                ('AR Rumaythah','Iraq','irak irag irac iraw','None',''),
                ('Abrams','Iraq','irak irag irac iraw','None',''),
                ('Abu Ghraib','Iraq','irak irag irac iraw','Abu Ghraib Prison BCC, Abu Ghurayh, Baghdad Central Detention Center',''),
                ('Abu Naji','Iraq','irak irag irac iraw','None',''),
                ('Adalla','Iraq','irak irag irac iraw','None',''),
                ('Adam','Iraq','irak irag irac iraw','None',''),
                ('Adder','Iraq','irak irag irac iraw','Al Taillil, Ali Air Base, Taillil',''),
                ('Aggies','Iraq','irak irag irac iraw','None',''),
                ('Aitha','Iraq','irak irag irac iraw','Cottrell',''),
                ('Akashat','Iraq','irak irag irac iraw','None',''),
                ('Al Abarrah','Iraq','irak irag irac iraw','None',''),
                ('Al Aleel','Iraq','irak irag irac iraw','None',''),
                ('Al Asad','Iraq','irak irag irac iraw','Al Asad Air Base, MCAS Al Asad, Rifles Base, Webster',''),
                ('Al Ashshar','Iraq','irak irag irac iraw','None',''),
                ('Al Aziziya','Iraq','irak irag irac iraw','None',''),
                ('Al Fahr','Iraq','irak irag irac iraw','None',''),
                ('Al Fallujah','Iraq','irak irag irac iraw','Patrol Base B, St. Mere',''),
                ('Al Farahidy','Iraq','irak irag irac iraw','None',''),
                ('Al Fattah','Iraq','irak irag irac iraw','None',''),
                ('Al Faw Peninsulsa','Iraq','irak irag irac iraw','Janin Al Few Penninsula',''),
                ('Al Habbaniyah','Iraq','irak irag irac iraw','Habbaniyah, Manhatan, Manhattan',''),
                ('Al Hartha','Iraq','irak irag irac iraw','None',''),
                ('Al Hayy','Iraq','irak irag irac iraw','Kut Al Hayy',''),
                ('Al Hiedier','Iraq','irak irag irac iraw','None',''),
                ('Al Hussein','Iraq','irak irag irac iraw','None',''),
                ('Al Iskandariyah','Iraq','irak irag irac iraw','Chosin, Dogwood FLB, Gela, JSS Iskan',''),
                ('Al Jadida','Iraq','irak irag irac iraw','None',''),
                ('Al Khansa','Iraq','irak irag irac iraw','None',''),
                ('Al Khidr','Iraq','irak irag irac iraw','None',''),
                ('Al Kindi','Iraq','irak irag irac iraw','None',''),
                ('Al Kisik','Iraq','irak irag irac iraw','None',''),
                ('Al Meerah','Iraq','irak irag irac iraw','None',''),
                ('Al Mina','Iraq','irak irag irac iraw','None',''),
                ('Al Muallimeen','Iraq','irak irag irac iraw','Nuab Dubat',''),
                ('Al Muthana','Iraq','irak irag irac iraw','None',''),
                ('Al Qaim','Iraq','irak irag irac iraw','Causey, Tiger Base',''),
                ('Al Qurna','Iraq','irak irag irac iraw','None',''),
                ('Al Shaab','Iraq','irak irag irac iraw','None',''),
                ('Al Tib','Iraq','irak irag irac iraw','Al Tib, PB Uvanni, Samarra',''),
                ('Al Tun Kapri','Iraq','irak irag irac iraw','None',''),
                ('Al Walid','Iraq','irak irag irac iraw','Latham, Waleed',''),
                ('Al Zubidiyah','Iraq','irak irag irac iraw','None',''),
                ('Alamo','Iraq','irak irag irac iraw','None',''),
                ('Albu Hyatt','Iraq','irak irag irac iraw','None',''),
                ('Alpha','Iraq','irak irag irac iraw','Al Hillah, Babylon Palace',''),
                ('Ameriyah','Iraq','irak irag irac iraw','None',''),
                ('An Najaf','Iraq','irak irag irac iraw','Najaf',''),
                ('Andaloos','Iraq','irak irag irac iraw','None',''),
                ('Andrea','Iraq','irak irag irac iraw','Kulsu, PB Andrea, Phantom, Stone',''),
                ('Angur','Iraq','irak irag irac iraw','None',''),
                ('Animal','Iraq','irak irag irac iraw','None',''),
                ('Annihilators','Iraq','irak irag irac iraw','None',''),
                ('Apache - IZ','Iraq','irak irag irac iraw','Al Sheeb, Al Wahab',''),
                ('Aqur quf','Iraq','irak irag irac iraw','None',''),
                ('Ar Ramadi','Iraq','irak irag irac iraw','Al Ramadi, Junction City, Ramadi, Rifles West',''),
                ('Ares','Iraq','irak irag irac iraw','Aryes',''),
                ('Arlington','Iraq','irak irag irac iraw','Arlington CEA Depot',''),
                ('Aruba','Iraq','irak irag irac iraw','None',''),
                ('As Sadah','Iraq','irak irag irac iraw','None',''),
                ('As Sindiyah Bridge','Iraq','irak irag irac iraw','As Sindiyah MJB FL',''),
                ('As Zubayr Port','Iraq','irak irag irac iraw','AZP',''),
                ('Ash Shura','Iraq','irak irag irac iraw','None',''),
                ('Ashreen','Iraq','irak irag irac iraw','None',''),
                ('Assassin Main','Iraq','irak irag irac iraw','Camp Ruhlen',''),
                ('Assassin','Iraq','irak irag irac iraw','None',''),
                ('Atlas','Iraq','irak irag irac iraw','None',''),
                ('Attack','Iraq','irak irag irac iraw','None',''),
                ('Aztec','Iraq','irak irag irac iraw','None',''),
                ('BOR','Iraq','irak irag irac iraw','None',''),
                ('BP Hassa','Iraq','irak irag irac iraw','None',''),
                ('BP Hue City','Iraq','irak irag irac iraw','None',''),
                ('Baath Party HQ','Iraq','irak irag irac iraw','None',''),
                ('Bab Al-Mouadam','Iraq','irak irag irac iraw','Rasheed',''),
                ('Babil','Iraq','irak irag irac iraw','None',''),
                ('Badoush','Iraq','irak irag irac iraw','None',''),
                ('Baghdad Island','Iraq','irak irag irac iraw','Bandit Island',''),
                ('Baghdad-Bandit Island','Iraq','irak irag irac iraw','Bandit Island',''),
                ('Baharia','Iraq','irak irag irac iraw','Dreamland, Fallujah, Vulturno',''),
                ('Baker','Iraq','irak irag irac iraw','None',''),
                ('Bali','Iraq','irak irag irac iraw','Pathfinder',''),
                ('Bama','Iraq','irak irag irac iraw','None',''),
                ('Barbarian','Iraq','irak irag irac iraw','PB Barbarian',''),
                ('Basrah Air Station','Iraq','irak irag irac iraw','BAS',''),
                ('Basrah Maqal','Iraq','irak irag irac iraw','None',''),
                ('Basrah Palace','Iraq','irak irag irac iraw','South Palace',''),
                ('Bassam','Iraq','irak irag irac iraw','None',''),
                ('Battle','Iraq','irak irag irac iraw','None',''),
                ('Bayji','Iraq','irak irag irac iraw','None',''),
                ('Beladiyat','Iraq','irak irag irac iraw','None',''),
                ('Bernstein','Iraq','irak irag irac iraw','Tuz Military Airfield',''),
                ('Besmaya Range','Iraq','irak irag irac iraw','Besmiyah Range',''),
                ('Black Foot','Iraq','irak irag irac iraw','None',''),
                ('Black Lions','Iraq','irak irag irac iraw','None',''),
                ('Black','Iraq','irak irag irac iraw','None',''),
                ('Blackfoot','Iraq','irak irag irac iraw','Gimlet, Khalis, Rock',''),
                ('Blackhawk','Iraq','irak irag irac iraw','None',''),
                ('Blue Diamond','Iraq','irak irag irac iraw','None',''),
                ('Bonzai DJSS','Iraq','irak irag irac iraw','None',''),
                ('Border Fort 9','Iraq','irak irag irac iraw','None',''),
                ('Brassfield','Iraq','irak irag irac iraw','Mora',''),
                ('Bravo','Iraq','irak irag irac iraw','None',''),
                ('Breadbasket','Iraq','irak irag irac iraw','None',''),
                ('Bucca','Iraq','irak irag irac iraw','None',''),
                ('Buckmaster','Iraq','irak irag irac iraw','None',''),
                ('Buhritz','Iraq','irak irag irac iraw','None',''),
                ('Bulldog','Iraq','irak irag irac iraw','None',''),
                ('Bushmaster - IZ','Iraq','irak irag irac iraw','None',''),
                ('Bushmaster 1','Iraq','irak irag irac iraw','None',''),
                ('Bushmaster 2','Iraq','irak irag irac iraw','None',''),
                ('Butler Range Complex','Iraq','irak irag irac iraw','None',''),
                ('Buzz','Iraq','irak irag irac iraw','None',''),
                ('CMOC','Iraq','irak irag irac iraw','None',''),
                ('COP 4','Iraq','irak irag irac iraw','None',''),
                ('COP 727','Iraq','irak irag irac iraw','None',''),
                ('COP 763','Iraq','irak irag irac iraw','None',''),
                ('COP 799','Iraq','irak irag irac iraw','None',''),
                ('COP 821','Iraq','irak irag irac iraw','JSS Sadiyah II, Warpath',''),
                ('COP 828','Iraq','irak irag irac iraw','None',''),
                ('COP 838','Iraq','irak irag irac iraw','None',''),
                ('COP 9','Iraq','irak irag irac iraw','None',''),
                ('COP Hotel','Iraq','irak irag irac iraw','None',''),
                ('COP North','Iraq','irak irag irac iraw','None',''),
                ('COP Nu Hamza','Iraq','irak irag irac iraw','None',''),
                ('COP South','Iraq','irak irag irac iraw','None',''),
                ('COP Subak Sur','Iraq','irak irag irac iraw','None',''),
                ('COP Tash','Iraq','irak irag irac iraw','None',''),
                ('COS Irbil','Iraq','irak irag irac iraw','None',''),
                ('CSH Warehouse','Iraq','irak irag irac iraw','None',''),
                ('CTCP Support House','Iraq','irak irag irac iraw','None',''),
                ('Cahill','Iraq','irak irag irac iraw','None',''),
                ('Caldwell','Iraq','irak irag irac iraw','KMTB, Kirkush Military Training Base, Kirkush NIA Training Facility',''),
                ('Callahan','Iraq','irak irag irac iraw','COS Callahan',''),
                ('Camp AL Saad','Iraq','irak irag irac iraw','None',''),
                ('Camp Buffalo','Iraq','irak irag irac iraw','None',''),
                ('Camp Cougar','Iraq','irak irag irac iraw','FOB Cougar, Freedom',''),
                ('Camp Daniels','Iraq','irak irag irac iraw','FOB Daniels, Samarra',''),
                ('Camp Eden','Iraq','irak irag irac iraw','None',''),
                ('Camp Gator','Iraq','irak irag irac iraw','FOB Gator',''),
                ('Camp Hutch','Iraq','irak irag irac iraw','None',''),
                ('Camp Khalid','Iraq','irak irag irac iraw','None',''),
                ('Camp Stephen','Iraq','irak irag irac iraw','None',''),
                ('Canal','Iraq','irak irag irac iraw','None',''),
                ('Carpenter','Iraq','irak irag irac iraw','Wyatt',''),
                ('Carver','Iraq','irak irag irac iraw','None',''),
                ('Cashe North','Iraq','irak irag irac iraw','COP Cashe North, Tuwaitha',''),
                ('Cashe South','Iraq','irak irag irac iraw','None',''),
                ('Castle','Iraq','irak irag irac iraw','None',''),
                ('Cavalier','Iraq','irak irag irac iraw','None',''),
                ('Cedar II','Iraq','irak irag irac iraw','None',''),
                ('Charlie','Iraq','irak irag irac iraw','Al Hillah, Bravo',''),
                ('Cherokee','Iraq','irak irag irac iraw','None',''),
                ('Chindit','Iraq','irak irag irac iraw','None',''),
                ('Choate','Iraq','irak irag irac iraw','Melody, Spartan Main',''),
                ('Chosen','Iraq','irak irag irac iraw','None',''),
                ('Cleary','Iraq','irak irag irac iraw','None',''),
                ('Cobra','Iraq','irak irag irac iraw','Badgerville, Balad BOS-1, Jalula',''),
                ('Cold Steel','Iraq','irak irag irac iraw','None',''),
                ('Comanche','Iraq','irak irag irac iraw','None',''),
                ('Combat Outpost','Iraq','irak irag irac iraw','AG College',''),
                ('Commanche','Iraq','irak irag irac iraw','None',''),
                ('Command Liason Element Compound','Iraq','irak irag irac iraw','CLE Compound, TFBSO, Taskforce Business Stability Operations',''),
                ('Commando Bar','Iraq','irak irag irac iraw','None',''),
                ('Condor','Iraq','irak irag irac iraw','None',''),
                ('Conqueror','Iraq','irak irag irac iraw','None',''),
                ('Constitution','Iraq','irak irag irac iraw','Camp Constitution, FOB Constitution',''),
                ('Corregidor','Iraq','irak irag irac iraw','None',''),
                ('Courage','Iraq','irak irag irac iraw','D-Main, Freedom, Mosul Palace',''),
                ('Craw','Iraq','irak irag irac iraw','AAK',''),
                ('Cross','Iraq','irak irag irac iraw','None',''),
                ('Crusader Main','Iraq','irak irag irac iraw','Camp Cowboy',''),
                ('Da Nang','Iraq','irak irag irac iraw','None',''),
                ('Dagger','Iraq','irak irag irac iraw','Raider, Raider Base',''),
                ('Dahuk Training Center 1','Iraq','irak irag irac iraw','Zawita Compound',''),
                ('Dahuk Training Center 2','Iraq','irak irag irac iraw','None',''),
                ('Danger','Iraq','irak irag irac iraw','Ironhorse',''),
                ('Delta - IZ','Iraq','irak irag irac iraw','Al Kut, Ubaydah Bin Al Jarrah Airfiled',''),
                ('Dezil','Iraq','irak irag irac iraw','None',''),
                ('Diamondback','Iraq','irak irag irac iraw','LSA Diamondback, Mosul Airfield',''),
                ('Dibbis','Iraq','irak irag irac iraw','None',''),
                ('Diwaniyah','Iraq','irak irag irac iraw','None',''),
                ('Diyala Governance Center','Iraq','irak irag irac iraw','None',''),
                ('Diyala Media Center','Iraq','irak irag irac iraw','COL DMC',''),
                ('Dogwood','Iraq','irak irag irac iraw','None',''),
                ('Dragon','Iraq','irak irag irac iraw','None',''),
                ('Duke','Iraq','irak irag irac iraw','None',''),
                ('Dur Rajaib Bridge','Iraq','irak irag irac iraw','Dur Rajaib MJB',''),
                ('Eagle Base','Iraq','irak irag irac iraw','None',''),
                ('Eastern Barracks','Iraq','irak irag irac iraw','None',''),
                ('Echo - IZ','Iraq','irak irag irac iraw','Ad Diwaniyah, Ad Diwanyah',''),
                ('Edge','Iraq','irak irag irac iraw','None',''),
                ('Ellis','Iraq','irak irag irac iraw','None',''),
                ('Embassy Annex','Iraq','irak irag irac iraw','None',''),
                ('Endeavor','Iraq','irak irag irac iraw','None',''),
                ('Essayons','Iraq','irak irag irac iraw','None',''),
                ('FTCP','Iraq','irak irag irac iraw','Camp Payne',''),
                ('Falcon','Iraq','irak irag irac iraw','Al Saqr, Ferrin Huggins',''),
                ('Fallahat','Iraq','irak irag irac iraw','None',''),
                ('Fat Boy Bridge','Iraq','irak irag irac iraw','Fat Boy MJB LSB',''),
                ('Fernandez','Iraq','irak irag irac iraw','None',''),
                ('Ford','Iraq','irak irag irac iraw','None',''),
                ('Fort Atterbury','Iraq','irak irag irac iraw','None',''),
                ('Fort','Iraq','irak irag irac iraw','None',''),
                ('Fortitude - IZ','Iraq','irak irag irac iraw','Patriot, Widowmaker',''),
                ('Fortress Lines','Iraq','irak irag irac iraw','None',''),
                ('Foxtrot - IZ','Iraq','irak irag irac iraw','None',''),
                ('Freedom Compound','Iraq','irak irag irac iraw','None',''),
                ('Freedom I','Iraq','irak irag irac iraw','Aggressor, Warhorse',''),
                ('Freedom II','Iraq','irak irag irac iraw','Regular',''),
                ('Freedom III','Iraq','irak irag irac iraw','None',''),
                ('Freedom Rest','Iraq','irak irag irac iraw','None',''),
                ('Gabe','Iraq','irak irag irac iraw','Boom, Hound, Scorpion Xray',''),
                ('Gaines Mills','Iraq','irak irag irac iraw','None',''),
                ('Gannon II','Iraq','irak irag irac iraw','None',''),
                ('Gannon','Iraq','irak irag irac iraw','Husaybah',''),
                ('Garry Owen','Iraq','irak irag irac iraw','None',''),
                ('Gaspar','Iraq','irak irag irac iraw','None',''),
                ('Gator','Iraq','irak irag irac iraw','None',''),
                ('Gatorswamp Bridge','Iraq','irak irag irac iraw','Gatorswamp MJB LSB',''),
                ('Ghazaliyah I','Iraq','irak irag irac iraw','None',''),
                ('Ghazaliyah II','Iraq','irak irag irac iraw','None',''),
                ('Ghazaliyah III','Iraq','irak irag irac iraw','None',''),
                ('Ghazaliyah','Iraq','irak irag irac iraw','None',''),
                ('Golf','Iraq','irak irag irac iraw','None',''),
                ('Grant','Iraq','irak irag irac iraw','None',''),
                ('Green Acres','Iraq','irak irag irac iraw','None',''),
                ('Green Zone','Iraq','irak irag irac iraw','None',''),
                ('Green','Iraq','irak irag irac iraw','None',''),
                ('Grierson','Iraq','irak irag irac iraw','None',''),
                ('Grizzly','Iraq','irak irag irac iraw','Ashraf, Barbarian',''),
                ('Guerrero','Iraq','irak irag irac iraw','None',''),
                ('Habur Gate','Iraq','irak irag irac iraw','Zahkho',''),
                ('Haditha','Iraq','irak irag irac iraw','None',''),
                ('Hadithah','Iraq','irak irag irac iraw','Hadithah Dam, Miller',''),
                ('Hamid','Iraq','irak irag irac iraw','None',''),
                ('Hammer','Iraq','irak irag irac iraw','None',''),
                ('Hashimiyah','Iraq','irak irag irac iraw','None',''),
                ('Hateen','Iraq','irak irag irac iraw','None',''),
                ('Hawas','Iraq','irak irag irac iraw','None',''),
                ('Hawijah','Iraq','irak irag irac iraw','None',''),
                ('Hawk','Iraq','irak irag irac iraw','None',''),
                ('Hawkes','Iraq','irak irag irac iraw','None',''),
                ('Hell Hound','Iraq','irak irag irac iraw','None',''),
                ('Hit','Iraq','irak irag irac iraw','Eden, Hit Training Center, NAEA Training Center',''),
                ('Honor','Iraq','irak irag irac iraw','Wolfpack Base',''),
                ('Hope','Iraq','irak irag irac iraw','Camp Eagle, War Eagle',''),
                ('Hor Al Bash','Iraq','irak irag irac iraw','None',''),
                ('Hotel','Iraq','irak irag irac iraw','None',''),
                ('Howell','Iraq','irak irag irac iraw','None',''),
                ('Hunter','Iraq','irak irag irac iraw','None',''),
                ('Hurricane Point','Iraq','irak irag irac iraw','None',''),
                ('Hurriyah II','Iraq','irak irag irac iraw','None',''),
                ('Hussiniyah','Iraq','irak irag irac iraw','None',''),
                ('IBA','Iraq','irak irag irac iraw','None',''),
                ('IMN','Iraq','irak irag irac iraw','None',''),
                ('IT2','Iraq','irak irag irac iraw','None',''),
                ('Ibrahim Bin Ali','Iraq','irak irag irac iraw','None',''),
                ('Imam Mansour','Iraq','irak irag irac iraw','None',''),
                ('Independence','Iraq','irak irag irac iraw','Muthana',''),
                ('India','Iraq','irak irag irac iraw','Karbala',''),
                ('Inman','Iraq','irak irag irac iraw','None',''),
                ('Intisar','Iraq','irak irag irac iraw','None',''),
                ('Irbil Residence Office','Iraq','irak irag irac iraw','None',''),
                ('Iron','Iraq','irak irag irac iraw','None',''),
                ('Iskan','Iraq','irak irag irac iraw','None',''),
                ('Islanders','Iraq','irak irag irac iraw','None',''),
                ('Istiqlal','Iraq','irak irag irac iraw','None',''),
                ('JBB','Iraq','irak irag irac iraw','Anaconda , Balad, Joint Base Balad',''),
                ('JSS 18','Iraq','irak irag irac iraw','Joint Security Station 18',''),
                ('JSS 2','Iraq','irak irag irac iraw','None',''),
                ('JSS Adhamiyah','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Awad','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Ezdehar','Iraq','irak irag irac iraw','Al Ezdehar, Ezdehar',''),
                ('JSS Al Jameat','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Qanat','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Rashid 2','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Rashid','Iraq','irak irag irac iraw','None',''),
                ('JSS Al Wahida','Iraq','irak irag irac iraw','Recon',''),
                ('JSS Anbar Provisional Covernment Center','Iraq','irak irag irac iraw','JSS Anbar PGC',''),
                ('JSS Bab Al Sheihk','Iraq','irak irag irac iraw','None',''),
                ('JSS Basateen','Iraq','irak irag irac iraw','None',''),
                ('JSS Commanche','Iraq','irak irag irac iraw','None',''),
                ('JSS Deason','Iraq','irak irag irac iraw','None',''),
                ('JSS Diamond','Iraq','irak irag irac iraw','None',''),
                ('JSS Hamiyah','Iraq','irak irag irac iraw','None',''),
                ('JSS Haswah','Iraq','irak irag irac iraw','None',''),
                ('JSS Hotel','Iraq','irak irag irac iraw','COP Hotel',''),
                ('JSS Hurriyah','Iraq','irak irag irac iraw','None',''),
                ('JSS Jabella','Iraq','irak irag irac iraw','None',''),
                ('JSS Jurf','Iraq','irak irag irac iraw','None',''),
                ('JSS Kumayt','Iraq','irak irag irac iraw','None',''),
                ('JSS Mahmood','Iraq','irak irag irac iraw','None',''),
                ('JSS Masafee','Iraq','irak irag irac iraw','None',''),
                ('JSS Mushada','Iraq','irak irag irac iraw','None',''),
                ('JSS Mutanabe','Iraq','irak irag irac iraw','JSS 1',''),
                ('JSS Mutanabi','Iraq','irak irag irac iraw','None',''),
                ('JSS Salaam','Iraq','irak irag irac iraw','None',''),
                ('JSS Salamiyat','Iraq','irak irag irac iraw','None',''),
                ('JSS Scorpian','Iraq','irak irag irac iraw','None',''),
                ('JSS Sheikh Marouf','Iraq','irak irag irac iraw','None',''),
                ('JSS Siniyah','Iraq','irak irag irac iraw','None',''),
                ('JSS Tal Abtah','Iraq','irak irag irac iraw','None',''),
                ('JSS Thawra II','Iraq','irak irag irac iraw','None',''),
                ('JSS Tomahawk','Iraq','irak irag irac iraw','None',''),
                ('JSS Umms ah','Iraq','irak irag irac iraw','None',''),
                ('JSS Ur','Iraq','irak irag irac iraw','None',''),
                ('JSS Wahida','Iraq','irak irag irac iraw','None',''),
                ('JSS Youngblood','Iraq','irak irag irac iraw','None',''),
                ('Jaguar','Iraq','irak irag irac iraw','None',''),
                ('Jenkins','Iraq','irak irag irac iraw','JSS Jenkins',''),
                ('Joint Coordination Center Abu Ghraib','Iraq','irak irag irac iraw','JCC Abu Ghraib',''),
                ('Juiaba','Iraq','irak irag irac iraw','None',''),
                ('Juliet','Iraq','irak irag irac iraw','None',''),
                ('Jumayah','Iraq','irak irag irac iraw','None',''),
                ('Justice','Iraq','irak irag irac iraw','Banzai, Dakota, Hunte',''),
                ('Juwarin AFB','Iraq','irak irag irac iraw','None',''),
                ('K-1','Iraq','irak irag irac iraw','None',''),
                ('K-3','Iraq','irak irag irac iraw','None',''),
                ('KILO','Iraq','irak irag irac iraw','None',''),
                ('Kaiser','Iraq','irak irag irac iraw','None',''),
                ('Kalsu','Iraq','irak irag irac iraw','None',''),
                ('Karada','Iraq','irak irag irac iraw','None',''),
                ('Key West','Iraq','irak irag irac iraw','None',''),
                ('Khadairy','Iraq','irak irag irac iraw','Al Shorta, Askari',''),
                ('Khadra','Iraq','irak irag irac iraw','None',''),
                ('Khaffijayah','Iraq','irak irag irac iraw','None',''),
                ('Khatoon','Iraq','irak irag irac iraw','None',''),
                ('Knight','Iraq','irak irag irac iraw','None',''),
                ('Korean Village','Iraq','irak irag irac iraw','Byers',''),
                ('Kubaysah','Iraq','irak irag irac iraw','None',''),
                ('LSA Geiger','Iraq','irak irag irac iraw','None',''),
                ('Lee','Iraq','irak irag irac iraw','None',''),
                ('Lima','Iraq','irak irag irac iraw','None',''),
                ('Lion - IZ','Iraq','irak irag irac iraw','None',''),
                ('Love','Iraq','irak irag irac iraw','None',''),
                ('Loyalty','Iraq','irak irag irac iraw','Camp Dragoon, Ironhorse, Patriot',''),
                ('Lutifiyah','Iraq','irak irag irac iraw','JSS Lutifiyah, Patrol Base Lutifiyah',''),
                ('MacKenzie','Iraq','irak irag irac iraw','Pacesetter, Samarra',''),
                ('Magic Mountain','Iraq','irak irag irac iraw','None',''),
                ('Mahmudiyah','Iraq','irak irag irac iraw','Al Mahmudiyah, Italy, St. Michael',''),
                ('Makhmur','Iraq','irak irag irac iraw','None',''),
                ('Malaab','Iraq','irak irag irac iraw','None',''),
                ('Manchester','Iraq','irak irag irac iraw','None',''),
                ('Marez','Iraq','irak irag irac iraw','Glory, Performance',''),
                ('Marlboro','Iraq','irak irag irac iraw','None',''),
                ('Martyrs Monument','Iraq','irak irag irac iraw','None',''),
                ('McHenry','Iraq','irak irag irac iraw','None',''),
                ('Meade','Iraq','irak irag irac iraw','None',''),
                ('Mercury','Iraq','irak irag irac iraw','ABU GHARAB, ABU GHURAYB',''),
                ('Midland','Iraq','irak irag irac iraw','None',''),
                ('Milledge','Iraq','irak irag irac iraw','None',''),
                ('Minden','Iraq','irak irag irac iraw','None',''),
                ('Mittica','Iraq','irak irag irac iraw','Family Quarters',''),
                ('Mobile','Iraq','irak irag irac iraw','None',''),
                ('Mohawk','Iraq','irak irag irac iraw','None',''),
                ('Morehead','Iraq','irak irag irac iraw','None',''),
                ('Motor Head Bridge','Iraq','irak irag irac iraw','Motor Head MJB Float Bridge',''),
                ('Mountain','Iraq','irak irag irac iraw','None',''),
                ('Mudaysis','Iraq','irak irag irac iraw','None',''),
                ('Mujema','Iraq','irak irag irac iraw','None',''),
                ('Mullalah 2','Iraq','irak irag irac iraw','None',''),
                ('Mullalah','Iraq','irak irag irac iraw','None',''),
                ('Munshada East','Iraq','irak irag irac iraw','None',''),
                ('Muntheria','Iraq','irak irag irac iraw','None',''),
                ('Murray','Iraq','irak irag irac iraw','None',''),
                ('Mustang Ranch','Iraq','irak irag irac iraw','None',''),
                ('Nasir Wa Salam','Iraq','irak irag irac iraw','None',''),
                ('Nasser','Iraq','irak irag irac iraw','JSS Nasser',''),
                ('Nepsa','Iraq','irak irag irac iraw','None',''),
                ('Nimr','Iraq','irak irag irac iraw','None',''),
                ('Normandy','Iraq','irak irag irac iraw','COS Normandy, Cobra, Khanaqin',''),
                ('Norris','Iraq','irak irag irac iraw','None',''),
                ('Norseman','Iraq','irak irag irac iraw','None',''),
                ('North Retrans','Iraq','irak irag irac iraw','None',''),
                ('Nott','Iraq','irak irag irac iraw','None',''),
                ('Nubai','Iraq','irak irag irac iraw','None',''),
                ('Nukhayb','Iraq','irak irag irac iraw','None',''),
                ('Numaniyah','Iraq','irak irag irac iraw','None',''),
                ('OP Burgess','Iraq','irak irag irac iraw','None',''),
                ('OP Castillo','Iraq','irak irag irac iraw','None',''),
                ('OP Graceland','Iraq','irak irag irac iraw','None',''),
                ('ORyan','Iraq','irak irag irac iraw','Lion',''),
                ('Obaid','Iraq','irak irag irac iraw','None',''),
                ('Ocotal','Iraq','irak irag irac iraw','None',''),
                ('Old State Building','Iraq','irak irag irac iraw','None',''),
                ('Omaha','Iraq','irak irag irac iraw','None',''),
                ('PB A','Iraq','irak irag irac iraw','Crazyhorse',''),
                ('PB Arrowhead','Iraq','irak irag irac iraw','None',''),
                ('PB Copper','Iraq','irak irag irac iraw','None',''),
                ('PB Corregidor','Iraq','irak irag irac iraw','None',''),
                ('PB Diyarah','Iraq','irak irag irac iraw','None',''),
                ('PB Dolby','Iraq','irak irag irac iraw','None',''),
                ('PB Doria','Iraq','irak irag irac iraw','None',''),
                ('PB Hillah','Iraq','irak irag irac iraw','Al Hillah',''),
                ('PB Inchon - IZ','Iraq','irak irag irac iraw','None',''),
                ('PB Kaufman','Iraq','irak irag irac iraw','None',''),
                ('PB Kelsey','Iraq','irak irag irac iraw','None',''),
                ('PB Kemple','Iraq','irak irag irac iraw','None',''),
                ('PB Lions Den','Iraq','irak irag irac iraw','None',''),
                ('PB Mahawil','Iraq','irak irag irac iraw','None',''),
                ('PB Mamah Khan','Iraq','irak irag irac iraw','Momenkhan',''),
                ('PB Mchale','Iraq','irak irag irac iraw','None',''),
                ('PB Okinawa','Iraq','irak irag irac iraw','None',''),
                ('PB Olson','Iraq','irak irag irac iraw','COS Olson, Patrol Base Olson',''),
                ('PB Raider','Iraq','irak irag irac iraw','None',''),
                ('PB Razor','Iraq','irak irag irac iraw','None',''),
                ('PB Tahadi','Iraq','irak irag irac iraw','None',''),
                ('PB Tamooz','Iraq','irak irag irac iraw','None',''),
                ('PB Vanderhorn','Iraq','irak irag irac iraw','None',''),
                ('PB Yates','Iraq','irak irag irac iraw','None',''),
                ('PB Yusifiyah','Iraq','irak irag irac iraw','PB Yusifiyah, Yusafiah, Yusufiyah',''),
                ('PJCC Nasiriyah','Iraq','irak irag irac iraw','None',''),
                ('Paladin','Iraq','irak irag irac iraw','None',''),
                ('Paliwoda','Iraq','irak irag irac iraw','Eagle Base',''),
                ('Patton','Iraq','irak irag irac iraw','None',''),
                ('Phoenix - IZ','Iraq','irak irag irac iraw','Dahuk CMOC',''),
                ('Power','Iraq','irak irag irac iraw','None',''),
                ('Prosperity Exclusion','Iraq','irak irag irac iraw','None',''),
                ('Prosperity','Iraq','irak irag irac iraw','Highlander Compound, LSA Highlander',''),
                ('Pump House Barney','Iraq','irak irag irac iraw','None',''),
                ('Q-West','Iraq','irak irag irac iraw','Endurance, JAG North, Qayyarah West, Regulars',''),
                ('Qalat Salih Airfield','Iraq','irak irag irac iraw','None',''),
                ('Qasr Amijj','Iraq','irak irag irac iraw','COP 160K, Qasr Amil',''),
                ('Qatana','Iraq','irak irag irac iraw','None',''),
                ('Rabbat','Iraq','irak irag irac iraw','None',''),
                ('Rabiy','Iraq','irak irag irac iraw','None',''),
                ('Radwaniyah Palace Complex','Iraq','irak irag irac iraw','None',''),
                ('Radwaniyah','Iraq','irak irag irac iraw','None',''),
                ('Rasheed','Iraq','irak irag irac iraw','Bab Al Mouadam',''),
                ('Rawah','Iraq','irak irag irac iraw','None',''),
                ('Rawashid','Iraq','irak irag irac iraw','None',''),
                ('Reaper - IZ','Iraq','irak irag irac iraw','None',''),
                ('Red Falcon','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 1','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 10','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 11','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 12','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 18','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 2','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 3','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 4','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 5','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 6','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 7','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 8','Iraq','irak irag irac iraw','None',''),
                ('Relay Point 9','Iraq','irak irag irac iraw','None',''),
                ('Remagan','Iraq','irak irag irac iraw','Packhorse',''),
                ('Retrans South','Iraq','irak irag irac iraw','None',''),
                ('Reyanah','Iraq','irak irag irac iraw','None',''),
                ('Riggs','Iraq','irak irag irac iraw','None',''),
                ('Rivera','Iraq','irak irag irac iraw','None',''),
                ('Riverside','Iraq','irak irag irac iraw','None',''),
                ('Rock','Iraq','irak irag irac iraw','None',''),
                ('Rough Rider','Iraq','irak irag irac iraw','None',''),
                ('Round Top','Iraq','irak irag irac iraw','None',''),
                ('Rowad','Iraq','irak irag irac iraw','None',''),
                ('Rusafa','Iraq','irak irag irac iraw','None',''),
                ('Rustamiyah','Iraq','irak irag irac iraw','Al Rastymia, Al Rusamiyah, Camp Cuervo, Dakota, Muleskinner',''),
                ('Sab Al Bour','Iraq','irak irag irac iraw','None',''),
                ('Sabataj','Iraq','irak irag irac iraw','JSS Sabataj',''),
                ('Sadiyah','Iraq','irak irag irac iraw','None',''),
                ('Safwan Hill','Iraq','irak irag irac iraw','None',''),
                ('Sagrah','Iraq','irak irag irac iraw','None',''),
                ('Sahl Sinjare','Iraq','irak irag irac iraw','None',''),
                ('Salie','Iraq','irak irag irac iraw','None',''),
                ('Salman Pak','Iraq','irak irag irac iraw','None',''),
                ('Sandi','Iraq','irak irag irac iraw','None',''),
                ('Saqlawiyah','Iraq','irak irag irac iraw','None',''),
                ('Scania','Iraq','irak irag irac iraw','None',''),
                ('Scimitar','Iraq','irak irag irac iraw','None',''),
                ('Scorpion North','Iraq','irak irag irac iraw','None',''),
                ('Scunion','Iraq','irak irag irac iraw','None',''),
                ('Sedgwick','Iraq','irak irag irac iraw','None',''),
                ('Shaheed Sufan','Iraq','irak irag irac iraw','Al Sin AA',''),
                ('Shaibah Log Base','Iraq','irak irag irac iraw','Camp Hutch, Steelback',''),
                ('Shanghai','Iraq','irak irag irac iraw','None',''),
                ('Sharqat','Iraq','irak irag irac iraw','None',''),
                ('Shatt Al Arab Hotel','Iraq','irak irag irac iraw','SAAH',''),
                ('Sheik Amir','Iraq','irak irag irac iraw','None',''),
                ('Sheik Hamad Village','Iraq','irak irag irac iraw','None',''),
                ('Shield','Iraq','irak irag irac iraw','Provider, Volunteer',''),
                ('Shocker','Iraq','irak irag irac iraw','None',''),
                ('Shuhada','Iraq','irak irag irac iraw','None',''),
                ('Shulla','Iraq','irak irag irac iraw','None',''),
                ('Sifer','Iraq','irak irag irac iraw','None',''),
                ('Silver','Iraq','irak irag irac iraw','None',''),
                ('Sinjar Retrans','Iraq','irak irag irac iraw','None',''),
                ('Smitty','Iraq','irak irag irac iraw','As Samawa, Camp Samawah, Relay Point 19',''),
                ('Snake Pit','Iraq','irak irag irac iraw','None',''),
                ('Solidarity','Iraq','irak irag irac iraw','Camp Ruhlen',''),
                ('South Angels','Iraq','irak irag irac iraw','None',''),
                ('South','Iraq','irak irag irac iraw','None',''),
                ('Spartan','Iraq','irak irag irac iraw','None',''),
                ('Spear','Iraq','irak irag irac iraw','None',''),
                ('Speicher','Iraq','irak irag irac iraw','Al Sahra, Iron Castle, Sycamore, Tikrit Air Base',''),
                ('Stable','Iraq','irak irag irac iraw','None',''),
                ('Stack House','Iraq','irak irag irac iraw','None',''),
                ('Stadium Al Amarah','Iraq','irak irag irac iraw','None',''),
                ('Stark','Iraq','irak irag irac iraw','None',''),
                ('Steel','Iraq','irak irag irac iraw','None',''),
                ('Steelback','Iraq','irak irag irac iraw','None',''),
                ('Stoddard','Iraq','irak irag irac iraw','None',''),
                ('Stone - IZ','Iraq','irak irag irac iraw','None',''),
                ('Sugar Shack','Iraq','irak irag irac iraw','None',''),
                ('Sulaminiyah Residence','Iraq','irak irag irac iraw','None',''),
                ('Summerall','Iraq','irak irag irac iraw','FOB Lancer, K2',''),
                ('Summers','Iraq','irak irag irac iraw','None',''),
                ('Suse','Iraq','irak irag irac iraw','None',''),
                ('Sykes','Iraq','irak irag irac iraw','Fulda, Munsan, Tall Afar',''),
                ('Taji Echo Area','Iraq','irak irag irac iraw','None',''),
                ('Taji','Iraq','irak irag irac iraw','Al Tadji, Camp Cooke, Tomahawk Village',''),
                ('Talon','Iraq','irak irag irac iraw','None',''),
                ('Tannumah','Iraq','irak irag irac iraw','None',''),
                ('Taqqadum','Iraq','irak irag irac iraw','Ridgeway, Taqaddum, Taqqaddum',''),
                ('Tarmiyah','Iraq','irak irag irac iraw','None',''),
                ('Tharallah','Iraq','irak irag irac iraw','None',''),
                ('Thawra I','Iraq','irak irag irac iraw','None',''),
                ('Thaylat','Iraq','irak irag irac iraw','None',''),
                ('Thunder','Iraq','irak irag irac iraw','Thunder Dome',''),
                ('Timberwolf','Iraq','irak irag irac iraw','None',''),
                ('Tinderbox','Iraq','irak irag irac iraw','None',''),
                ('Torch','Iraq','irak irag irac iraw','None',''),
                ('Trebil','Iraq','irak irag irac iraw','None',''),
                ('Ubaydi','Iraq','irak irag irac iraw','None',''),
                ('Um Quasr','Iraq','irak irag irac iraw','Umm Qsar',''),
                ('Union I','Iraq','irak irag irac iraw','None',''),
                ('Union II','Iraq','irak irag irac iraw','None',''),
                ('Union III','Iraq','irak irag irac iraw','None',''),
                ('Ur','Iraq','irak irag irac iraw','COP 329',''),
                ('Uvanni','Iraq','irak irag irac iraw','PB Uvanni, Patrol Base Uvanni',''),
                ('VBC Area IV','Iraq','irak irag irac iraw','None',''),
                ('VBC Cropper','Iraq','irak irag irac iraw','None',''),
                ('VBC Liberty','Iraq','irak irag irac iraw','Blackjack, North Victory',''),
                ('VBC Seitz','Iraq','irak irag irac iraw','Log Base Seitz',''),
                ('VBC Slayer','Iraq','irak irag irac iraw','Abu Ghurayb Presidential Ground, Camp Deutsch',''),
                ('VBC Striker','Iraq','irak irag irac iraw','None',''),
                ('VBC Victory','Iraq','irak irag irac iraw','Camp Brooklyn, South Victory, Victory MNC-1',''),
                ('VBC West BIAP','Iraq','irak irag irac iraw','Dublin, JMMT on Camp West Biap, MEDCOM, Muthana, Sather, West Bagdad International Airport',''),
                ('Vanguard','Iraq','irak irag irac iraw','None',''),
                ('Viking','Iraq','irak irag irac iraw','None',''),
                ('Wadi Al Khirr New Afld','Iraq','irak irag irac iraw','None',''),
                ('Wahid Bridge','Iraq','irak irag irac iraw','Wahid MJB',''),
                ('Wahida','Iraq','irak irag irac iraw','None',''),
                ('Wallah','Iraq','irak irag irac iraw','None',''),
                ('War Eagle','Iraq','irak irag irac iraw','None',''),
                ('Warhorse','Iraq','irak irag irac iraw','None',''),
                ('Warrior - IZ','Iraq','irak irag irac iraw','Bayonet, Kirkurk, Main',''),
                ('Warrior Keep','Iraq','irak irag irac iraw','None',''),
                ('Washash','Iraq','irak irag irac iraw','None',''),
                ('Wessam','Iraq','irak irag irac iraw','None',''),
                ('Whiskey 1','Iraq','irak irag irac iraw','None',''),
                ('White Falcon','Iraq','irak irag irac iraw','None',''),
                ('Whitehorse','Iraq','irak irag irac iraw','None',''),
                ('Wilson - IZ','Iraq','irak irag irac iraw','Arrow',''),
                ('Wolf','Iraq','irak irag irac iraw','None',''),
                ('Zafaraniya','Iraq','irak irag irac iraw','None',''),
                ('Zahra','Iraq','irak irag irac iraw','None',''),
                ('Zaytun','Iraq','irak irag irac iraw','Irbil',''),
                ('Zeimer','Iraq','irak irag irac iraw','None',''),
                ('Zubadiyah Bridge','Iraq','irak irag irac iraw','Zubadiyah MJB',''),
                ('Zukhaykha','Iraq','irak irag irac iraw','None',''),
                ('Zulu','Iraq','irak irag irac iraw','None',''),
                ('none','Kuwait','kwait kuwaite kawait quwait kuwaitt kuwat kuwati kuwai kwuait kuwit','KU',''),
                ('none','Oman','omani omni topman oma mani goman','MU',''),
                ('none','Persian Gulf','persion persain perisan pesian perian persijian pursian persin percian','6P',''),
                ('none','Qatar','quatar qutar qater katar','QA',''),
                ('none','Red Sea','','6E',''),
                ('none','Saudi Arabia','saudia suadi saudi saud soudi saudie sadia sqaud arabi arbia aribia araibia caraboa arabea araiba aabia arabai','SA',''),
                ('none','United Arab Emirates','','AE (UAE)','')
                               )
       AS MasterRecord(Base, Country, other_Names, Names, Province)
       )
INSERT INTO [AHOBPR].[STD_DEPLOYMENT_LOCATION]
           ([BASE]
           ,[COUNTRY]
           ,[OTHER_NAMES]
           ,[NAMES]
           ,[PROVINCE]
           ,[USER_ADDED_FLAG]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
   SELECT Base, Country, other_Names, Names, Province, 0, @UserName, @UserName, @Today, @Today
     FROM MasterData AS Src;
  
  UPDATE [AHOBPR].[STD_DEPLOYMENT_LOCATION]
     SET BASE = NULL
   WHERE BASE = 'none';

END
;     
GO
PRINT 'Merging data for [AHOBPR].[STD_REGISTRY_FLAG_TYPE]...'; 
GO

DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               ('Administrative Flag', 'Administrative Flag'),
               ('SubPopulation Flag', 'SubPopulation Flag')
               )
       AS MasterRecord(TYPE, DESCRIPTION)
       )
MERGE
  INTO  [AHOBPR].[STD_REGISTRY_FLAG_TYPE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[REGISTRY_FLAG_TYPE] = Src.TYPE
  WHEN  MATCHED
  THEN  UPDATE
        SET [REGISTRY_FLAG_TYPE] = Src.TYPE,
            [REGISTRY_FLAG_TYPE_DESCRIPTION] = Src.DESCRIPTION,
            UPDATEDBY = @UserName,   
            UPDATED = @Today
 WHEN  NOT MATCHED
 THEN  INSERT
        ([REGISTRY_FLAG_TYPE], [REGISTRY_FLAG_TYPE_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
        VALUES
        (Src.TYPE, Src.DESCRIPTION, @UserName, @UserName, @Today, @Today)
;            
GO

PRINT 'Merging data for [AHOBPR].[STD_BRANCH_OF_SERVICE]...'; 
GO

DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               ('US Army'),
               ('US Navy'),
               ('US Marine Corps'),
               ('Air Force'))
       AS MasterRecord(BRANCH)
       )
MERGE
  INTO  [AHOBPR].[STD_BRANCH_OF_SERVICE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[BRANCH_OF_SERVICE] = Src.BRANCH
 WHEN  NOT MATCHED
 THEN  INSERT
        ([BRANCH_OF_SERVICE], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
        VALUES
        (Src.BRANCH, @UserName, @UserName, @Today,@Today)
;            
GO

IF NOT EXISTS(SELECT * FROM [AHOBPR].[STD_REGISTRY_FLAG])
  BEGIN
    PRINT 'Loading predefined data for AHOBPR.STD_REGISTRY_FLAG...'
   
    DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
    DECLARE @Today DateTime2 = GETDATE();

    /****** Object:  Table [AHOBPR].[STD_FORM]    Script Date: 11/17/2014 10:54:38 ******/
	SET IDENTITY_INSERT [AHOBPR].[STD_REGISTRY_FLAG] ON
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, N'Status Change: "Review" to "Eligible"', N'Status Change by VA Staff: "Review" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, N'Status Change: "Review" to "Review Not-Eligible"', N'Status Change by VA Staff: "Review" to "Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, N'Status Change: "Not-Eligible" to "Eligible"', N'Status Change by VA Staff: "Not-Eligible" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, N'Status Change: "Not-Eligible" to"Review Not-Eligible"', N'Status Change by VA Staff: "Not-Eligible" to"Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, N'Status Change: "Review Not-Eligible" to "Eligible"', N'Status Change by VA Staff: "Review Not-Eligible" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, N'Status Change: "Review Not-Eligible" to "Review Not-Eligible"', N'Status Change by VA Staff: "Review Not-Eligible" to "Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, N'Status Change: "Participant" to "Eligible"', N'Status Change by VA Staff: "Participant" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, N'Status Change: "Participant" to"Review Not-Eligible"', N'Status Change by VA Staff: "Participant" to"Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, N'Status Change: "No Consent" to "Eligible"', N'Status Change by VA Staff: "No Consent" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, N'Status Change: "No Consent" to "Review Not-Eligible"', N'Status Change by VA Staff: "No Consent" to "Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, N'Status Change: "Consent" to "Eligible"', N'Status Change by VA Staff: "Consent" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, N'Status Change: "Consent" to"Review Not-Eligible"', N'Status Change by VA Staff: "Consent" to"Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, N'Status Change: "Eligible" to "Eligible"', N'Status Change by VA Staff: "Eligible" to "Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, N'Status Change: "Eligible" to "Review Not-Eligible"', N'Status Change by VA Staff: "Eligible" to "Review Not-Eligible"', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	INSERT [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID], [REGISTRY_FLAG_NAME], [REGISTRY_FLAG_DESCRIPTION], [STD_REGISTRY_FLAG_TYPE_ID], [ACTIVE_FLAG], [PREDEFINED], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, N'Review-HEC', N'Review - Health Eligibility Center', 1, 1, 1, @UserName, @UserName, @Today, @Today)
	SET IDENTITY_INSERT [AHOBPR].[STD_REGISTRY_FLAG] OFF
  END;
GO

IF NOT EXISTS(SELECT * FROM [AHOBPR].[STD_FORM])
  BEGIN
    PRINT 'Loading STD FORM and related tables...'
   
    DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
    DECLARE @Today DateTime2 = GETDATE();

    /****** Object:  Table [AHOBPR].[STD_CONCEPT]    Script Date: 11/17/2014 10:54:38 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_CONCEPT] ON
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, N'DARE Questionnaire H2-5c', N'H2-5c', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, N'DARE Questionnaire Page 14 Section G', N'Section G', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, N'Medical Research Chronic (MRC) Breathlessness scale', N'MRC Breathlessness scale', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, N'ACN.130_00.000', N'ACN.130_00.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, N'ACN.125_00.100', N'ACN.125_00.100', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, N'ACN.125_00.130', N'ACN.125_00.130', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, N'ACN.125_00.250', N'ACN.125_00.250', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, N'ACN.201_05.000', N'ACN.201_05.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, N'Adult Conditions ACN.031 series', N'ACN.031 series', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, N'Adult Conditions ACN.035 series', N'ACN.035 series', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, N'Adult Conditions ACN.080_00.000', N'ACN.080_00.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, N'Adult Health Behaviors AHB.010_00.000', N'AHB.010_00.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, N'Adult Health Status & Limitations starting with AHS.091_01.000', N'AHS.091_01.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, N'Adult Access to Health Care & Utilization, AAU.305_00.000', N'AAU.305_00.000', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, N'Never smoked regularly', N'Never smoked regularly', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, N'I do not wish to answer', N'I do not wish to answer', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, N'Don''t know', N'Don''t know', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, N'Other impairment/problem (Specify one).', N'Other', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, N'Coding System/Lexicon', N'Coding System/Lexicon', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, N'National Health Interview Survey', N'NHIS', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, N'United States Army Public Health Command', N'DoD USAPHC', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (24, N'Modified Medical Research Chronic (MRC) Breathlessness scale', N'MMRC', @UserName, @UserName, @Today,@Today)
    INSERT [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID], [DESCRIPTION], [SHORT_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (25, N'Center for Disease Control Survey Answer codes', N'CDC Survey', @UserName, @UserName, @Today,@Today)
    SET IDENTITY_INSERT [AHOBPR].[STD_CONCEPT] OFF

    /****** Object:  Table [AHOBPR].[STD_TERM]    Script Date: 11/17/2014 10:54:38 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_TERM] ON
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, 21, NULL, N'_SYSTEM_', N'Coding System', N'AHOBPR List of Coding System', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, 22, 1, N'_NHIS_', N'NHIS', N'National Health Interview Survey', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, 23, 1, N'_DoDUSAPHC_', N'DoD USAPHC', N'United States Army Public Health Command', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, 24, 1, N'_MMRCDyspnoeaScale_', N'MMRC', N'Modified Medical Research Chronic (MRC) Breathlessness scale', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, 25, 1, N'_CDCSurveyResponse_', N'CDC Survey', N'Center for Disease Control Survey Answer codes', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, 1, 3, N'H2-5c', N'H2-5c', N'DARE Questionnaire H2-5c', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, 2, 3, N'Section G', N'Section G', N'DARE Questionnaire Page 14 Section G', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, 3, 4, N'MRC', N'MRC Breathlessness scale', N'Medical Research Chronic (MRC) Breathlessness scale', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, 4, 2, N'ACN.130_00.000', N'ACN.130_00.000', N'ACN.130_00.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, 5, 2, N'ACN.125_00.100', N'ACN.125_00.100', N'ACN.125_00.100', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, 6, 2, N'ACN.125_00.130', N'ACN.125_00.130', N'ACN.125_00.130', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, 7, 2, N'ACN.125_00.250', N'ACN.125_00.250', N'ACN.125_00.250', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, 8, 2, N'ACN.201_05.000', N'ACN.201_05.000', N'ACN.201_05.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, 9, 2, N'ACN.031', N'ACN.031 series', N'Adult Conditions ACN.031 series', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, 10, 2, N'ACN.035', N'ACN.035 series', N'Adult Conditions ACN.035 series', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, 11, 2, N'ACN.080_00.000', N'ACN.080_00.000', N'Adult Conditions ACN.080_00.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, 12, 2, N'AHB.010_00.000', N'AHB.010_00.000', N'Adult Health Behaviors AHB.010_00.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, 13, 2, N'AHS.091_01.000', N'AHS.091_01.000', N'Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (19, 14, 2, N'AAU.305_00.000', N'AAU.305_00.000', N'Adult Access to Health Care & Utilization, AAU.305_00.000', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (20, 15, 5, N'96', N'Never smoked regularly', N'Never smoked regularly', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, 16, 5, N'97', N'I do not wish to answer', N'I do not wish to answer', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, 17, 5, N'99', N'Don''t know', N'Don''t know', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_TERM] ([STD_TERM_ID], [STD_CONCEPT_ID], [SYSTEM_STD_TERM_ID], [CODE], [SHORT_DESCRIPTION], [DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, 18, 5, N'90', N'Other', N'Other impairment/problem (Specify one).', @UserName, @UserName, @Today, @Today)
    SET IDENTITY_INSERT [AHOBPR].[STD_TERM] OFF

    /****** Object:  Table [AHOBPR].[STD_FORM]    Script Date: 01/20/2015 11:39:07 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM] ON
    INSERT [AHOBPR].[STD_FORM] ([STD_FORM_ID], [NAME], [VERSION], [TITLE], [OMB], [BPR_FORM_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, N'bpr', N'2014.03.18.08', N'Open Burn Pit Registry', N'2900-0800', 3, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM] ([STD_FORM_ID], [NAME], [VERSION], [TITLE], [OMB], [BPR_FORM_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, N'bpr', N'2014.03.18.04', N'Open Burn Pit Registry', N'2900-0800', 2, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM] ([STD_FORM_ID], [NAME], [VERSION], [TITLE], [OMB], [BPR_FORM_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, N'bpr', N'2014.03.18.02', N'Open Burn Pit Registry', N'2900-0800', 1, @UserName, @UserName, @Today, @Today)
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM] OFF
    /****** Object:  Table [AHOBPR].[STD_FORM_SECTION]    Script Date: 01/20/2015 11:39:08 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_SECTION] ON
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, 1, N'Eligible Deployment History', N'', N'', N'', N'', 1, 1, N'Deployment History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, 1, N'Symptoms and Medical History', N'Tell us your health history. Please list all conditions even if you don''t think they''re related to a deployment exposure.', N'', N'', N'', 1, 2, N'Symptoms & Medical History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, 1, N'Health Concerns', N'Help us focus our efforts on health issues you care about.', N'', N'', N'', 1, 3, N'Health Concerns', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, 1, N'Places You''ve Lived', N'Poor air quality in places where you lived may impact how deployment exposures affect you.', N'', N'', N'', 1, 4, N'Places You''ve Lived', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, 1, N'Work History', N'Exposures in your non-military jobs may impact how deployment exposures affect you.', N'', N'', N'', 1, 5, N'Work History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, 1, N'Home Environment and Hobbies', N'Exposures in your home environment or hobbies may impact how deployment exposures affect you.', N'', N'', N'', 1, 6, N'Home Environment & Hobbies', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, 1, N'Health Care Utilization', N'', N'', N'', N'', 1, 7, N'Health Care Utilization', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, 1, N'Contact Preferences', N'Help us communicate in ways that are most effective. VA will review these responses to determine the best ways to conduct outreach.', N'', N'', N'', 1, 8, N'Contact Preferences', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, 3, N'Eligible Deployment History', N'', N'', N'', N'', 1, 1, N'Deployment History (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, 3, N'Symptoms and Medical History', N'Tell us your health history. Please list all conditions even if you don''t think they''re related to a deployment exposure.', N'', N'', N'', 1, 2, N'Symptoms & Medical History (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, 3, N'Health Concerns', N'Help us focus our efforts on health issues you care about.', N'', N'', N'', 1, 3, N'Health Concerns (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, 3, N'Places You''ve Lived', N'Poor air quality in places where you lived may impact how deployment exposures affect you.', N'', N'', N'', 1, 4, N'Places You''ve Lived (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, 3, N'Work History', N'Exposures in your non-military jobs may impact how deployment exposures affect you.', N'', N'', N'', 1, 5, N'Work History (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, 3, N'Home Environment and Hobbies', N'Exposures in your home environment or hobbies may impact how deployment exposures affect you.', N'', N'', N'', 1, 6, N'Home Environment & Hobbies (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, 3, N'Health Care Utilization', N'', N'', N'', N'', 1, 7, N'Health Care Utilization (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, 3, N'Contact Preferences', N'Help us communicate in ways that are most effective. VA will review these responses to determine the best ways to conduct outreach.', N'', N'', N'', 1, 8, N'Contact Preferences (V1)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, 4, N'Eligible Deployment History', N'', N'', N'', N'', 1, 1, N'Deployment History (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, 4, N'Symptoms and Medical History', N'Tell us your health history. Please list all conditions even if you don''t think they''re related to a deployment exposure.', N'', N'', N'', 1, 2, N'Symptoms & Medical History (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (19, 4, N'Health Concerns', N'Help us focus our efforts on health issues you care about.', N'', N'', N'', 1, 3, N'Health Concerns (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (20, 4, N'Places You''ve Lived', N'Poor air quality in places where you lived may impact how deployment exposures affect you.', N'', N'', N'', 1, 4, N'Places You''ve Lived (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, 4, N'Work History', N'Exposures in your non-military jobs may impact how deployment exposures affect you.', N'', N'', N'', 1, 5, N'Work History (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, 4, N'Home Environment and Hobbies', N'Exposures in your home environment or hobbies may impact how deployment exposures affect you.', N'', N'', N'', 1, 6, N'Home Environment & Hobbies (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, 4, N'Health Care Utilization', N'', N'', N'', N'', 1, 7, N'Health Care Utilization (V2)', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [DESCRIPTION], [NOTES], [LINE_NUMBER], [BRP_FORM_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (24, 4, N'Contact Preferences', N'Help us communicate in ways that are most effective. VA will review these responses to determine the best ways to conduct outreach.', N'', N'', N'', 1, 8, N'Contact Preferences (V2)', @UserName, @UserName, @Today, @Today)
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_SECTION] OFF
    /****** Object:  Table [AHOBPR].[STD_FORM_SUB_SECTION]    Script Date: 01/20/2015 11:39:08 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ON
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, 1, 1, N'Deployment Data from the VA Defense Information Repository (VADIR) and other sources', N'', N'', 1, N'Deployments', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, 1, 1, N'Location Specific Deployment Exposures', N'Tell us about  potential exposures while you were deployed', N'', 2, N'Deployment Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, 1, 1, N'General Military Occupational Exposures', N'During <strong>any</strong> of your deployments:', N'', 3, N'Military Occupational Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, 1, 1, N'Environmental Exposures, Regional Air Pollution', N'', N'', 4, N'Environmental Exposures & Air Pollution', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, 2, 1, N'Functional Limitation and Reported Cause', N'', N'', 1, N'Functional Limitation & Reported Cause', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, 2, 1, N'Health Conditions', N'', N'', 2, N'Health Conditions', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, 2, 1, N'Height and Weight', N'', N'', 3, N'Height & Weight', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, 2, 1, N'Cancer History', N'', N'', 4, N'Cancer History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, 2, 1, N'Tobacco Exposure', N'', N'', 5, N'Tobacco Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, 2, 1, N'Deployment Smoking History', N'', N'', 6, N'Deployment Smoking History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, 2, 1, N'12 Month Alcohol Use', N'', N'', 7, N'12 Month Alcohol Use', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, 3, 1, N'Health Concerns', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, 4, 1, N'Places You''ve Lived', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, 5, 1, N'Current Occupational Status', N'', N'', 1, N'Current Occupational Status', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, 5, 1, N'Main Occupation', N'', N'', 2, N'Main Occupation', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, 5, 1, N'Dust Exposures', N'', N'', 3, N'Dust Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, 5, 1, N'Gas, Smoke, Vapors or Fumes Exposure?', N'', N'', 4, N'Gas, Smoke, Vapors or Fumes Exposure?', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, 5, 1, N'Asbestos Exposure', N'', N'', 5, N'Asbestos Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (19, 6, 1, N'Home Environment, Community, and Hobbies (Environmental Exposures)', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (20, 7, 1, N'Health Care Utilization', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, 8, 1, N'Contact Preferences', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, 9, 3, N'Deployment Data from the VA Defense Information Repository (VADIR) and other sources', N'', N'', 1, N'Deployments', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, 9, 3, N'Location Specific Deployment Exposures', N'Tell us about  potential exposures while you were deployed', N'', 2, N'Deployment Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (24, 9, 3, N'General Military Occupational Exposures', N'During <strong>any</strong> of your deployments:', N'', 3, N'Military Occupational Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (25, 9, 3, N'Environmental Exposures, Regional Air Pollution', N'', N'', 4, N'Environmental Exposures & Air Pollution', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (26, 10, 3, N'Functional Limitation and Reported Cause', N'', N'', 1, N'Functional Limitation & Reported Cause', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (27, 10, 3, N'Health Conditions', N'', N'', 2, N'Health Conditions', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (28, 10, 3, N'Height and Weight', N'', N'', 3, N'Height & Weight', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (29, 10, 3, N'Cancer History', N'', N'', 4, N'Cancer History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (30, 10, 3, N'Tobacco Exposure', N'', N'', 5, N'Tobacco Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (31, 10, 3, N'Deployment Smoking History', N'', N'', 6, N'Deployment Smoking History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (32, 10, 3, N'12 Month Alcohol Use', N'', N'', 7, N'12 Month Alcohol Use', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (33, 11, 3, N'Health Concerns', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (34, 12, 3, N'Places You''ve Lived', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (35, 13, 3, N'Current Occupational Status', N'', N'', 1, N'Current Occupational Status', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (36, 13, 3, N'Main Occupation', N'', N'', 2, N'Main Occupation', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (37, 13, 3, N'Dust Exposures', N'', N'', 3, N'Dust Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (38, 13, 3, N'Gas, Smoke, Vapors or Fumes Exposure?', N'', N'', 4, N'Gas, Smoke, Vapors or Fumes Exposure?', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (39, 13, 3, N'Asbestos Exposure', N'', N'', 5, N'Asbestos Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (40, 14, 3, N'Home Environment, Community, and Hobbies (Environmental Exposures)', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (41, 15, 3, N'Health Care Utilization', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (42, 16, 3, N'Contact Preferences', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (43, 17, 4, N'Deployment Data from the VA Defense Information Repository (VADIR) and other sources', N'', N'', 1, N'Deployments', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (44, 17, 4, N'Location Specific Deployment Exposures', N'Tell us about  potential exposures while you were deployed', N'', 2, N'Deployment Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (45, 17, 4, N'General Military Occupational Exposures', N'During <strong>any</strong> of your deployments:', N'', 3, N'Military Occupational Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (46, 17, 4, N'Environmental Exposures, Regional Air Pollution', N'', N'', 4, N'Environmental Exposures & Air Pollution', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (47, 18, 4, N'Functional Limitation and Reported Cause', N'', N'', 1, N'Functional Limitation & Reported Cause', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (48, 18, 4, N'Health Conditions', N'', N'', 2, N'Health Conditions', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (49, 18, 4, N'Height and Weight', N'', N'', 3, N'Height & Weight', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (50, 18, 4, N'Cancer History', N'', N'', 4, N'Cancer History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (51, 18, 4, N'Tobacco Exposure', N'', N'', 5, N'Tobacco Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (52, 18, 4, N'Deployment Smoking History', N'', N'', 6, N'Deployment Smoking History', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (53, 18, 4, N'12 Month Alcohol Use', N'', N'', 7, N'12 Month Alcohol Use', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (54, 19, 4, N'Health Concerns', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (55, 20, 4, N'Places You''ve Lived', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (56, 21, 4, N'Current Occupational Status', N'', N'', 1, N'Current Occupational Status', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (57, 21, 4, N'Main Occupation', N'', N'', 2, N'Main Occupation', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (58, 21, 4, N'Dust Exposures', N'', N'', 3, N'Dust Exposures', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (59, 21, 4, N'Gas, Smoke, Vapors or Fumes Exposure?', N'', N'', 4, N'Gas, Smoke, Vapors or Fumes Exposure?', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (60, 21, 4, N'Asbestos Exposure', N'', N'', 5, N'Asbestos Exposure', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (61, 22, 4, N'Home Environment, Community, and Hobbies (Environmental Exposures)', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (62, 23, 4, N'Health Care Utilization', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TITLE], [INTRODUCTION], [CONCLUSION], [BRP_FORM_SUB_SECTION_ID], [MENU_ITEM_NAME], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (63, 24, 4, N'Contact Preferences', N'', N'', 1, N'', @UserName, @UserName, @Today, @Today)
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_SUB_SECTION] OFF
    /****** Object:  Table [AHOBPR].[STD_FORM_QUESTION]    Script Date: 01/20/2015 11:39:07 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_QUESTION] ON
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (1, 1, 1, 1, N'Deployment History', N'text', N'', N'', 1, NULL, NULL, N'1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Deployment History')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (2, 2, 1, 1, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (3, 2, 1, 1, N'Where did you spend <strong>most</strong> of your time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where did you spend most of your time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (4, 2, 1, 1, N'If you were at more than one base, where did you spend the <strong>second most</strong> amount of time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If you were at more than one base, where did you spend the second most amount of time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (5, 2, 1, 1, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (6, 2, 1, 1, N'Who ran this burn pit? (select all that apply)', N'multiSelect', N'', N'', 3, NULL, NULL, N'1.2.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Who ran this burn pit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (7, 2, 1, 1, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (8, 2, 1, 1, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your <strong>work site or housing</strong>?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your work site or housing?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (9, 2, 1, 1, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (10, 2, 1, 1, N'On a <strong>typical day</strong>, how many hours were you near (for example you could smell or see it) sewage ponds?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you near (for example you could smell or see it) sewage ponds?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (11, 3, 1, 1, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (12, 3, 1, 1, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (13, 3, 1, 1, N'In a typical month, how many days were you in convoy or other vehicle operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you in convoy or other vehicle operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (14, 3, 1, 1, N'In a typical month, how many days did you perform refueling operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform refueling operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (15, 3, 1, 1, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (16, 3, 1, 1, N'In a typical month, how many days did you perform construction duties?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform construction duties?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (17, 3, 1, 1, N'In a typical month, how many days did you perform pesticide duties for your unit?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform pesticide duties for your unit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (18, 4, 1, 1, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (19, 4, 1, 1, N'What did you do differently (select all that apply)?', N'multiSelect', N'', N'', 10, NULL, NULL, N'1.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What did you do differently?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (20, 4, 1, 1, N'In a typical month during your deployment(s), how many days did you experience dust storms?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month during your deployment(s), how many days did you experience dust storms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (21, 4, 1, 1, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (22, 4, 1, 1, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (23, 4, 1, 1, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (24, 5, 2, 1, N'How difficult is it to run or jog one mile on a level surface?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'How difficult is it to run or jog one mile on a level surface?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (25, 5, 2, 1, N'How difficult is it to walk on a level surface for one mile?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk on a level surface for one mile?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (26, 5, 2, 1, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (27, 5, 2, 1, N'How difficult is it to walk up a hill or incline?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up a hill or incline?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (28, 5, 2, 1, N'How difficult is it to walk up 10 steps or climb a flight of stairs?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up 10 steps or climb a flight of stairs?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (29, 5, 2, 1, N'What condition or health problem causes you to have difficulty with these activities? (Check all that apply.)', N'multiSelect', N'', N'', 36, NULL, NULL, N'2.1.F', N'F', N'', NULL, NULL, N'', N'', N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'What condition or health problem causes you to have difficulty with these activities?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (30, 6, 2, 1, N'Respiratory Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.1', N'1', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Conditions ACN.031 series', @UserName, @UserName, @Today, @Today, N'Respiratory Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (31, 6, 2, 1, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.A', N'1.A', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (32, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had asthma?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.B', N'1.B', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.080_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had asthma?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (33, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had emphysema?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.C', N'1.C', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had emphysema?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (34, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic bronchitis?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.D', N'1.D', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic bronchitis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (35, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.E', N'1.E', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.035 series', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (36, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.F', N'1.F', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (37, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.G', N'1.G', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (38, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.H', N'1.H', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (39, 6, 2, 1, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment? (che', N'multiSelect', N'', N'', 3, NULL, 30, N'2.2.1.I', N'1.I', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (40, 6, 2, 1, N'Did this lung disease get better, worse, or about the same during deployment?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.J', N'1.J', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did this lung disease get better, worse, or about the same during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (41, 6, 2, 1, N'Do you currently have any of the following symptoms? (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.K', N'1.K', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have any of the following symptoms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (42, 6, 2, 1, N'In the past 12 months did you have any of the following symptoms (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.L', N'1.L', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In the past 12 months did you have any of the following symptoms')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (43, 6, 2, 1, N'How would you rate your shortness of breath or breathlessness? (check the description/grade that applies to you.)  I''m:', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.M', N'1.M', N'1', NULL, NULL, N'', N'', N'Medical Research Chronic (MRC) Breathlessness scale', @UserName, @UserName, @Today, @Today, N'How would you rate your shortness of breath or breathlessness? I''m:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (44, 6, 2, 1, N'Cardiovascular Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.2', N'2', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Cardiovascular Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (45, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.A', N'2.A', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (46, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had coronary artery disease?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.B', N'2.B', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had coronary artery disease?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (47, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had angina pectoris?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.C', N'2.C', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had angina pectoris?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (48, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.D', N'2.D', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (49, 6, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.E', N'2.E', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (50, 6, 2, 1, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ', N'multiSelect', N'', N'', 3, NULL, 44, N'2.2.2.F', N'2.F', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (51, 6, 2, 1, N'Other Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.3', N'3', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (52, 6, 2, 1, N'During the <strong>past 12 months</strong>, have you regularly had insomnia or trouble sleeping?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.A', N'3.A', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.250', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you regularly had insomnia or trouble sleeping?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (53, 6, 2, 1, N'During the <strong>past 12 months</strong>, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs or difficulties', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.B', N'3.B', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.130', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (54, 6, 2, 1, N'During the <strong>past 12 months</strong>, have you had problems of the immune system?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.C', N'3.C', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.100', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had problems of the immune system?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (55, 6, 2, 1, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any kind of liver condition?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.D', N'3.D', N'3', NULL, NULL, N'', N'', N'NHIS ACN.201_05.000', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any kind of liver condition?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (56, 6, 2, 1, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness (examples include irritable bowel syndrome, chron', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.E', N'3.E', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (57, 6, 2, 1, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition <strong>first</strong> occur before, during, or after deployment? (check all that apply)', N'multiSelect', N'', N'', 3, NULL, 51, N'2.2.3.F', N'3.F', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition first occur before, during, or after deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (58, 6, 2, 1, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?', N'number', N'1', N'24', 1, NULL, 51, N'2.2.3.G', N'3.G', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (59, 6, 2, 1, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you <strong>and</strong> what you know about yourself.', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.H', N'3.H', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you and what you know about yourself.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (60, 6, 2, 1, N'How often do you have times when you stop breathing during your sleep?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.I', N'3.I', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How often do you have times when you stop breathing during your sleep?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (61, 7, 2, 1, N'How tall are you without shoes?', N'radioCompoundSelect', N'', N'', 1, NULL, NULL, N'2.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How tall are you without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (62, 7, 2, 1, N'How much do you weigh without shoes?', N'number', N'0', N'1000', 1, NULL, NULL, N'2.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How much do you weigh without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (63, 8, 2, 1, N'Have you <strong>ever</strong> been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS  ACN.130_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (64, 8, 2, 1, N'What kind of cancer was it? ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.B', N'B', N'', NULL, NULL, N'true', N'', N'', @UserName, @UserName, @Today, @Today, N'What kind of cancer was it? ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (65, 8, 2, 1, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (66, 8, 2, 1, N'If you were diagnosed with a second cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.D', N'D', N'', NULL, NULL, N'true', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a second cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (67, 8, 2, 1, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (68, 8, 2, 1, N'If you were diagnosed with a third cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.F', N'F', N'', NULL, NULL, N'true', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a third cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (69, 8, 2, 1, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.G', N'G', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (70, 9, 2, 1, N'Have you smoked at least 100 cigarettes in your entire life?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Behaviors: AHB.010_00.000', @UserName, @UserName, @Today, @Today, N'Have you smoked at least 100 cigarettes in your entire life?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (71, 9, 2, 1, N'How old were you when you first started to smoke fairly regularly?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How old were you when you first started to smoke fairly regularly?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (72, 9, 2, 1, N' Do you now smoke cigarettes every day, some days or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N' Do you now smoke cigarettes every day, some days or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (73, 9, 2, 1, N'How long has it been since you quit smoking?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.D', N'D', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How long has it been since you quit smoking?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (74, 9, 2, 1, N'On the average, how many cigarettes do you now smoke a day?', N'number', N'0', N'500', 1, NULL, NULL, N'2.5.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'On the average, how many cigarettes do you now smoke a day?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (75, 9, 2, 1, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (76, 9, 2, 1, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (77, 9, 2, 1, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (78, 9, 2, 1, N'Do you <strong>now</strong> use smokeless tobacco products every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now use smokeless tobacco products every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (79, 9, 2, 1, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (80, 10, 2, 1, N'Did you start smoking for the first time while being deployed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.A', N'A', NULL, NULL, NULL, NULL, NULL, N'DoD USAPHC DARE H2-5c', @UserName, @UserName, @Today, @Today, N'Did you start smoking for the first time while being deployed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (81, 10, 2, 1, N'How did deployment(s) change how much you smoked?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.B', N'B', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How did deployment(s) change how much you smoked?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (82, 11, 2, 1, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.7.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (83, 12, 3, 1, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (84, 12, 3, 1, N'During your deployment(s), do you believe you were sick because of something you breathed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), do you believe you were sick because of something you breathed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (85, 12, 3, 1, N'Do you <strong>currently</strong> have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (86, 12, 3, 1, N'When did the problem start?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When did the problem start?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (87, 12, 3, 1, N'Please rate your concern that something you breathed during deployment <strong>has already affected</strong> your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment has already affected your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (88, 12, 3, 1, N'Please identify your biggest health concern that something you breathed during deployment <strong>has already affected</strong> your health:', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment has already affected your health:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (89, 12, 3, 1, N'Have you discussed this concern with your health care provider, medical professional or team?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you discussed this concern with your health care provider, medical professional or team?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (90, 12, 3, 1, N'Are you concerned that <strong>in the future</strong> that your health will be affected by something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you concerned that in the future that your health will be affected by something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (91, 12, 3, 1, N'Please rate your concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (92, 12, 3, 1, N'Please identify your biggest health concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (93, 12, 3, 1, N'Which exposure do you think has the <strong>biggest</strong> overall effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.K', N'K', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Which exposure do you think has the biggest overall effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (94, 13, 4, 1, N'Is the address above your current address?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'4.1.ZZ', N'ZZ', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Is the address above your current address?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (95, 13, 4, 1, N'What is your current address? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.A', N'A', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is your current address? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (96, 13, 4, 1, N'Country', N'country', N'', N'', 1, NULL, 95, N'4.1.A.1', N'A.1', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (97, 13, 4, 1, N'City Name', N'text', N'', N'', 1, NULL, 95, N'4.1.A.2', N'A.2', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (98, 13, 4, 1, N'State', N'state', N'', N'', 1, NULL, 95, N'4.1.A.3', N'A.3', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (99, 13, 4, 1, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 95, N'4.1.A.4', N'A.4', N'A', 5, 5, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (100, 13, 4, 1, N'How many years have you lived at your current address (listed above)?', N'number', N'0', N'99', 1, NULL, 95, N'4.1.A.5', N'A.5', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years have you lived at your current address (listed above)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (101, 13, 4, 1, N'Do you live nine or more months of the year at the address listed above?', N'multipleChoice', N'', N'', 1, NULL, 95, N'4.1.A.6', N'A.6', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you live nine or more months of the year at the address listed above?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (102, 13, 4, 1, N'If not, indicate the other residence.', N'recursive', N'', N'', NULL, NULL, 95, N'4.1.A.7', N'A.7', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If not, indicate the other residence.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (103, 13, 4, 1, N'Other Country', N'country', N'', N'', 1, NULL, NULL, N'4.1.A.7.a', N'A.7.a', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (104, 13, 4, 1, N'Other City Name', N'text', N'', N'', 1, NULL, NULL, N'4.1.A.7.b', N'A.7.b', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (105, 13, 4, 1, N'Other state', N'state', N'', N'', 1, NULL, NULL, N'4.1.A.7.c', N'A.7.c', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other state')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (106, 13, 4, 1, N'Other zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, NULL, N'4.1.A.7.d', N'A.7.d', N'7', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (107, 13, 4, 1, N'Where have you lived the longest? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where have you lived the longest? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (108, 13, 4, 1, N'The address where I lived the longest is the same as my current address', N'multipleChoice', N'', N'', 1, NULL, 107, N'4.1.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'The address where I lived the longest is the same as my current address')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (109, 13, 4, 1, N'Country', N'country', N'', N'', 1, NULL, 107, N'4.1.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (110, 13, 4, 1, N'City Name', N'text', N'', N'', 1, NULL, 107, N'4.1.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (111, 13, 4, 1, N'State', N'state', N'', N'', 1, NULL, 107, N'4.1.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (112, 13, 4, 1, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 107, N'4.1.B.5', N'B.5', N'B', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (113, 13, 4, 1, N'Indicate the approximate year you moved to this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.6', N'B.6', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved to this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (114, 13, 4, 1, N'Indicate the approximate year you moved out of this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.7', N'B.7', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (115, 13, 4, 1, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (116, 13, 4, 1, N'Country', N'country', N'', N'', 1, NULL, 115, N'4.1.C.1', N'C.1', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (117, 13, 4, 1, N'City Name', N'text', N'', N'', 1, NULL, 115, N'4.1.C.2', N'C.2', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (118, 13, 4, 1, N'State', N'state', N'', N'', 1, NULL, 115, N'4.1.C.3', N'C.3', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (119, 13, 4, 1, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 115, N'4.1.C.4', N'C.4', N'C', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (120, 13, 4, 1, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.5', N'C.5', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (121, 13, 4, 1, N'Indicate the approximate age you moved out of this address.', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.6', N'C.6', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (122, 14, 5, 1, N'Which of the following were you doing last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Which of the following were you doing last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (123, 14, 5, 1, N'What is the main reason you did not work last week/have a job or business last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is the main reason you did not work last week/have a job or business last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (124, 15, 5, 1, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). <strong>Do not include your occupation during military service.</strong>  If your ', N'text', N'', N'', 1, NULL, NULL, N'5.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). Do not include your occupation during military service.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (125, 15, 5, 1, N'Total years in this non-military job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, NULL, N'5.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this non-military job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (126, 16, 5, 1, N'Have you ever worked for a year or more in any dusty job <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked for a year or more in any dusty job outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (127, 16, 5, 1, N'For the job with the biggest dust exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest dust exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (128, 16, 5, 1, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 127, N'5.3.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (129, 16, 5, 1, N'In this job, what were the most common kinds of dust to which you were exposed?', N'multiSelect', N'', N'', 20, NULL, 127, N'5.3.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of dust to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (130, 16, 5, 1, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 127, N'5.3.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (131, 16, 5, 1, N'Are you working in this dusty job now?', N'multipleChoice', N'', N'', 1, NULL, 127, N'5.3.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this dusty job now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (132, 17, 5, 1, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (133, 17, 5, 1, N'For the job with the biggest gas, smoke, vapor or fume exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest gas, smoke, vapor or fume exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (134, 17, 5, 1, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 133, N'5.4.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (135, 17, 5, 1, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?', N'multiSelect', N'', N'', 13, NULL, 133, N'5.4.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (136, 17, 5, 1, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 133, N'5.4.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (137, 17, 5, 1, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?', N'multipleChoice', N'', N'', 1, NULL, 133, N'5.4.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (138, 18, 5, 1, N'Have you ever worked in a job with asbestos exposure, including military service?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked in a job with asbestos exposure, including military service?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (139, 18, 5, 1, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (140, 18, 5, 1, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)', N'number', N'0', N'99', 1, NULL, NULL, N'5.5.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (141, 18, 5, 1, N'Are you working in a job with asbestos exposure now?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in a job with asbestos exposure now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (142, 19, 6, 1, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (143, 19, 6, 1, N'Have you ever removed mold in your home because of its effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever removed mold in your home because of its effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (144, 19, 6, 1, N'Have you ever lived in a home that had elevated radon levels?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever lived in a home that had elevated radon levels?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (145, 19, 6, 1, N'Please select from the list below any hobbies you participate in.', N'multiSelect', N'', N'', 7, NULL, NULL, N'6.D', N'D', N'', NULL, NULL, N'', N'', N'DoD USAPHC DARE questionnaire, page 14, section G', @UserName, @UserName, @Today, @Today, N'Please select from the list below any hobbies you participate in.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (146, 19, 6, 1, N'How many total hours a week, on average, do you participate in all the above hobbies combined?', N'number', N'0', N'168', 1, NULL, NULL, N'6.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many total hours a week, on average, do you participate in all the above hobbies combined?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (147, 20, 7, 1, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS: Adult Access to Health Care & Utilization, AAU.305_00.000', @UserName, @UserName, @Today, @Today, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (148, 20, 7, 1, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (149, 21, 8, 1, N'How do you prefer to receive updated information on burn pits and other airborne exposures?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How do you prefer to receive updated information on burn pits and other airborne exposures?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (150, 21, 8, 1, N'Do you use the internet?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you use the internet?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (151, 21, 8, 1, N'Do you send or receive emails?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you send or receive emails?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (303, 22, 9, 3, N'Deployment History', N'text', N'', N'', 1, NULL, NULL, N'1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Deployment History')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (304, 23, 9, 3, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (305, 23, 9, 3, N'Where did you spend <strong>most</strong> of your time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where did you spend most of your time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (306, 23, 9, 3, N'If you were at more than one base, where did you spend the <strong>second most</strong> amount of time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If you were at more than one base, where did you spend the second most amount of time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (307, 23, 9, 3, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (308, 23, 9, 3, N'Who ran this burn pit? (select all that apply)', N'multiSelect', N'', N'', 3, NULL, NULL, N'1.2.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Who ran this burn pit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (309, 23, 9, 3, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (310, 23, 9, 3, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your <strong>work site or housing</strong>?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your work site or housing?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (311, 23, 9, 3, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (312, 23, 9, 3, N'On a <strong>typical day</strong>, how many hours were you near (for example you could smell or see it) sewage ponds?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you near (for example you could smell or see it) sewage ponds?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (313, 24, 9, 3, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (314, 24, 9, 3, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (315, 24, 9, 3, N'In a typical month, how many days were you in convoy or other vehicle operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you in convoy or other vehicle operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (316, 24, 9, 3, N'In a typical month, how many days did you perform refueling operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform refueling operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (317, 24, 9, 3, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (318, 24, 9, 3, N'In a typical month, how many days did you perform construction duties?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform construction duties?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (319, 24, 9, 3, N'In a typical month, how many days did you perform pesticide duties for your unit?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform pesticide duties for your unit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (320, 25, 9, 3, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (321, 25, 9, 3, N'What did you do differently (select all that apply)?', N'multiSelect', N'', N'', 10, NULL, NULL, N'1.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What did you do differently?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (322, 25, 9, 3, N'In a typical month during your deployment(s), how many days did you experience dust storms?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month during your deployment(s), how many days did you experience dust storms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (323, 25, 9, 3, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (324, 25, 9, 3, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (325, 25, 9, 3, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (326, 26, 10, 3, N'How difficult is it to run or jog one mile on a level surface?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'How difficult is it to run or jog one mile on a level surface?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (327, 26, 10, 3, N'How difficult is it to walk on a level surface for one mile?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk on a level surface for one mile?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (328, 26, 10, 3, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (329, 26, 10, 3, N'How difficult is it to walk up a hill or incline?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up a hill or incline?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (330, 26, 10, 3, N'How difficult is it to walk up 10 steps or climb a flight of stairs?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up 10 steps or climb a flight of stairs?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (331, 26, 10, 3, N'What condition or health problem causes you to have difficulty with these activities? (Check all that apply.)', N'multiSelect', N'', N'', 36, NULL, NULL, N'2.1.F', N'F', N'', NULL, NULL, N'', N'', N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'What condition or health problem causes you to have difficulty with these activities?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (332, 27, 10, 3, N'Respiratory Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.1', N'1', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Conditions ACN.031 series', @UserName, @UserName, @Today, @Today, N'Respiratory Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (333, 27, 10, 3, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.A', N'1.A', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (334, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had asthma?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.B', N'1.B', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.080_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had asthma?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (335, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had emphysema?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.C', N'1.C', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had emphysema?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (336, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic bronchitis?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.D', N'1.D', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic bronchitis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (337, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.E', N'1.E', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.035 series', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (338, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.F', N'1.F', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (339, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.G', N'1.G', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (340, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.H', N'1.H', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (341, 27, 10, 3, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment? (che', N'multiSelect', N'', N'', 3, NULL, 30, N'2.2.1.I', N'1.I', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (342, 27, 10, 3, N'Did this lung disease get better, worse, or about the same during deployment?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.J', N'1.J', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did this lung disease get better, worse, or about the same during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (343, 27, 10, 3, N'Do you currently have any of the following symptoms? (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.K', N'1.K', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have any of the following symptoms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (344, 27, 10, 3, N'In the past 12 months did you have any of the following symptoms (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.L', N'1.L', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In the past 12 months did you have any of the following symptoms')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (345, 27, 10, 3, N'How would you rate your shortness of breath or breathlessness? (check the description/grade that applies to you.)  I''m:', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.M', N'1.M', N'1', NULL, NULL, N'', N'', N'Medical Research Chronic (MRC) Breathlessness scale', @UserName, @UserName, @Today, @Today, N'How would you rate your shortness of breath or breathlessness? I''m:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (346, 27, 10, 3, N'Cardiovascular Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.2', N'2', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Cardiovascular Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (347, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.A', N'2.A', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (348, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had coronary artery disease?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.B', N'2.B', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had coronary artery disease?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (349, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had angina pectoris?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.C', N'2.C', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had angina pectoris?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (350, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.D', N'2.D', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (351, 27, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.E', N'2.E', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (352, 27, 10, 3, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ', N'multiSelect', N'', N'', 3, NULL, 44, N'2.2.2.F', N'2.F', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (353, 27, 10, 3, N'Other Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.3', N'3', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (354, 27, 10, 3, N'During the <strong>past 12 months</strong>, have you regularly had insomnia or trouble sleeping?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.A', N'3.A', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.250', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you regularly had insomnia or trouble sleeping?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (355, 27, 10, 3, N'During the <strong>past 12 months</strong>, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs or difficulties', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.B', N'3.B', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.130', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (356, 27, 10, 3, N'During the <strong>past 12 months</strong>, have you had problems of the immune system?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.C', N'3.C', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.100', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had problems of the immune system?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (357, 27, 10, 3, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any kind of liver condition?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.D', N'3.D', N'3', NULL, NULL, N'', N'', N'NHIS ACN.201_05.000', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any kind of liver condition?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (358, 27, 10, 3, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness (examples include irritable bowel syndrome, chron', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.E', N'3.E', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (359, 27, 10, 3, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition <strong>first</strong> occur before, during, or after deployment? (check all that apply)', N'multiSelect', N'', N'', 3, NULL, 51, N'2.2.3.F', N'3.F', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition first occur before, during, or after deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (360, 27, 10, 3, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?', N'number', N'1', N'24', 1, NULL, 51, N'2.2.3.G', N'3.G', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (361, 27, 10, 3, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you <strong>and</strong> what you know about yourself.', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.H', N'3.H', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you and what you know about yourself.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (362, 27, 10, 3, N'How often do you have times when you stop breathing during your sleep?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.I', N'3.I', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How often do you have times when you stop breathing during your sleep?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (363, 28, 10, 3, N'How tall are you without shoes?', N'radioCompoundSelect', N'', N'', 1, NULL, NULL, N'2.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How tall are you without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (364, 28, 10, 3, N'How much do you weigh without shoes?', N'number', N'0', N'1000', 1, NULL, NULL, N'2.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How much do you weigh without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (365, 29, 10, 3, N'Have you <strong>ever</strong> been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS  ACN.130_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (366, 29, 10, 3, N'What kind of cancer was it? ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.B', N'B', N'', NULL, NULL, N'TRUE', N'', N'', @UserName, @UserName, @Today, @Today, N'What kind of cancer was it? ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (367, 29, 10, 3, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (368, 29, 10, 3, N'If you were diagnosed with a second cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.D', N'D', N'', NULL, NULL, N'TRUE', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a second cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (369, 29, 10, 3, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (370, 29, 10, 3, N'If you were diagnosed with a third cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.F', N'F', N'', NULL, NULL, N'TRUE', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a third cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (371, 29, 10, 3, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.G', N'G', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (372, 30, 10, 3, N'Have you smoked at least 100 cigarettes in your entire life?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Behaviors: AHB.010_00.000', @UserName, @UserName, @Today, @Today, N'Have you smoked at least 100 cigarettes in your entire life?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (373, 30, 10, 3, N'How old were you when you first started to smoke fairly regularly?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How old were you when you first started to smoke fairly regularly?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (374, 30, 10, 3, N' Do you now smoke cigarettes every day, some days or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N' Do you now smoke cigarettes every day, some days or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (375, 30, 10, 3, N'How long has it been since you quit smoking?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.D', N'D', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How long has it been since you quit smoking?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (376, 30, 10, 3, N'On the average, how many cigarettes do you now smoke a day?', N'number', N'0', N'500', 1, NULL, NULL, N'2.5.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'On the average, how many cigarettes do you now smoke a day?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (377, 30, 10, 3, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (378, 30, 10, 3, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (379, 30, 10, 3, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (380, 30, 10, 3, N'Do you <strong>now</strong> use smokeless tobacco products every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now use smokeless tobacco products every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (381, 30, 10, 3, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (382, 31, 10, 3, N'Did you start smoking for the first time while being deployed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.A', N'A', NULL, NULL, NULL, NULL, NULL, N'DoD USAPHC DARE H2-5c', @UserName, @UserName, @Today, @Today, N'Did you start smoking for the first time while being deployed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (383, 31, 10, 3, N'How did deployment(s) change how much you smoked?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.B', N'B', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How did deployment(s) change how much you smoked?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (384, 32, 10, 3, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.7.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (385, 33, 11, 3, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (386, 33, 11, 3, N'During your deployment(s), do you believe you were sick because of something you breathed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), do you believe you were sick because of something you breathed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (387, 33, 11, 3, N'Do you <strong>currently</strong> have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (388, 33, 11, 3, N'When did the problem start?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When did the problem start?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (389, 33, 11, 3, N'Please rate your concern that something you breathed during deployment <strong>has already affected</strong> your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment has already affected your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (390, 33, 11, 3, N'Please identify your biggest health concern that something you breathed during deployment <strong>has already affected</strong> your health:', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment has already affected your health:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (391, 33, 11, 3, N'Have you discussed this concern with your health care provider, medical professional or team?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you discussed this concern with your health care provider, medical professional or team?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (392, 33, 11, 3, N'Are you concerned that <strong>in the future</strong> that your health will be affected by something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you concerned that in the future that your health will be affected by something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (393, 33, 11, 3, N'Please rate your concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (394, 33, 11, 3, N'Please identify your biggest health concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (395, 33, 11, 3, N'Which exposure do you think has the <strong>biggest</strong> overall effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.K', N'K', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Which exposure do you think has the biggest overall effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (396, 34, 12, 3, N'Is the address above your current address?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'4.1.ZZ', N'ZZ', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Is the address above your current address?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (397, 34, 12, 3, N'What is your current address? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.A', N'A', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is your current address? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (398, 34, 12, 3, N'Country', N'country', N'', N'', 1, NULL, 95, N'4.1.A.1', N'A.1', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (399, 34, 12, 3, N'City Name', N'text', N'', N'', 1, NULL, 95, N'4.1.A.2', N'A.2', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (400, 34, 12, 3, N'State', N'state', N'', N'', 1, NULL, 95, N'4.1.A.3', N'A.3', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (401, 34, 12, 3, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 95, N'4.1.A.4', N'A.4', N'A', 5, 5, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (402, 34, 12, 3, N'How many years have you lived at your current address (listed above)?', N'number', N'0', N'99', 1, NULL, 95, N'4.1.A.5', N'A.5', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years have you lived at your current address (listed above)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (403, 34, 12, 3, N'Do you live nine or more months of the year at the address listed above?', N'multipleChoice', N'', N'', 1, NULL, 95, N'4.1.A.6', N'A.6', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you live nine or more months of the year at the address listed above?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (404, 34, 12, 3, N'If not, indicate the other residence.', N'recursive', N'', N'', NULL, NULL, 95, N'4.1.A.7', N'A.7', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If not, indicate the other residence.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (405, 34, 12, 3, N'Other Country', N'country', N'', N'', 1, NULL, NULL, N'4.1.A.7.a', N'A.7.a', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (406, 34, 12, 3, N'Other City Name', N'text', N'', N'', 1, NULL, NULL, N'4.1.A.7.b', N'A.7.b', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (407, 34, 12, 3, N'Other state', N'state', N'', N'', 1, NULL, NULL, N'4.1.A.7.c', N'A.7.c', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other state')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (408, 34, 12, 3, N'Other zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, NULL, N'4.1.A.7.d', N'A.7.d', N'7', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (409, 34, 12, 3, N'Where have you lived the longest? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where have you lived the longest? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (410, 34, 12, 3, N'The address where I lived the longest is the same as my current address', N'multipleChoice', N'', N'', 1, NULL, 107, N'4.1.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'The address where I lived the longest is the same as my current address')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (411, 34, 12, 3, N'Country', N'country', N'', N'', 1, NULL, 107, N'4.1.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (412, 34, 12, 3, N'City Name', N'text', N'', N'', 1, NULL, 107, N'4.1.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (413, 34, 12, 3, N'State', N'state', N'', N'', 1, NULL, 107, N'4.1.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (414, 34, 12, 3, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 107, N'4.1.B.5', N'B.5', N'B', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (415, 34, 12, 3, N'Indicate the approximate year you moved to this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.6', N'B.6', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved to this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (416, 34, 12, 3, N'Indicate the approximate year you moved out of this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.7', N'B.7', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (417, 34, 12, 3, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (418, 34, 12, 3, N'Country', N'country', N'', N'', 1, NULL, 115, N'4.1.C.1', N'C.1', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (419, 34, 12, 3, N'City Name', N'text', N'', N'', 1, NULL, 115, N'4.1.C.2', N'C.2', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (420, 34, 12, 3, N'State', N'state', N'', N'', 1, NULL, 115, N'4.1.C.3', N'C.3', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (421, 34, 12, 3, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 115, N'4.1.C.4', N'C.4', N'C', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (422, 34, 12, 3, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.5', N'C.5', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (423, 34, 12, 3, N'Indicate the approximate age you moved out of this address.', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.6', N'C.6', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (424, 35, 13, 3, N'Which of the following were you doing last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Which of the following were you doing last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (425, 35, 13, 3, N'What is the main reason you did not work last week/have a job or business last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is the main reason you did not work last week/have a job or business last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (426, 36, 13, 3, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). <strong>Do not include your occupation during military service.</strong>  If your ', N'text', N'', N'', 1, NULL, NULL, N'5.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). Do not include your occupation during military service.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (427, 36, 13, 3, N'Total years in this non-military job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, NULL, N'5.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this non-military job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (428, 37, 13, 3, N'Have you ever worked for a year or more in any dusty job <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked for a year or more in any dusty job outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (429, 37, 13, 3, N'For the job with the biggest dust exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest dust exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (430, 37, 13, 3, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 127, N'5.3.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (431, 37, 13, 3, N'In this job, what were the most common kinds of dust to which you were exposed?', N'multiSelect', N'', N'', 20, NULL, 127, N'5.3.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of dust to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (432, 37, 13, 3, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 127, N'5.3.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (433, 37, 13, 3, N'Are you working in this dusty job now?', N'multipleChoice', N'', N'', 1, NULL, 127, N'5.3.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this dusty job now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (434, 38, 13, 3, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (435, 38, 13, 3, N'For the job with the biggest gas, smoke, vapor or fume exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest gas, smoke, vapor or fume exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (436, 38, 13, 3, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 133, N'5.4.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (437, 38, 13, 3, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?', N'multiSelect', N'', N'', 13, NULL, 133, N'5.4.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (438, 38, 13, 3, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 133, N'5.4.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (439, 38, 13, 3, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?', N'multipleChoice', N'', N'', 1, NULL, 133, N'5.4.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (440, 39, 13, 3, N'Have you ever worked in a job with asbestos exposure, including military service?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked in a job with asbestos exposure, including military service?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (441, 39, 13, 3, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (442, 39, 13, 3, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)', N'number', N'0', N'99', 1, NULL, NULL, N'5.5.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (443, 39, 13, 3, N'Are you working in a job with asbestos exposure now?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in a job with asbestos exposure now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (444, 40, 14, 3, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (445, 40, 14, 3, N'Have you ever removed mold in your home because of its effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever removed mold in your home because of its effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (446, 40, 14, 3, N'Have you ever lived in a home that had elevated radon levels?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever lived in a home that had elevated radon levels?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (447, 40, 14, 3, N'Please select from the list below any hobbies you participate in.', N'multiSelect', N'', N'', 7, NULL, NULL, N'6.D', N'D', N'', NULL, NULL, N'', N'', N'DoD USAPHC DARE questionnaire, page 14, section G', @UserName, @UserName, @Today, @Today, N'Please select from the list below any hobbies you participate in.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (448, 40, 14, 3, N'How many total hours a week, on average, do you participate in all the above hobbies combined?', N'number', N'0', N'168', 1, NULL, NULL, N'6.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many total hours a week, on average, do you participate in all the above hobbies combined?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (449, 41, 15, 3, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS: Adult Access to Health Care & Utilization, AAU.305_00.000', @UserName, @UserName, @Today, @Today, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (450, 41, 15, 3, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (451, 42, 16, 3, N'How do you prefer to receive updated information on burn pits and other airborne exposures?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How do you prefer to receive updated information on burn pits and other airborne exposures?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (452, 42, 16, 3, N'Do you use the internet?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you use the internet?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (453, 42, 16, 3, N'Do you send or receive emails?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you send or receive emails?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (454, 43, 17, 4, N'Deployment History', N'text', N'', N'', 1, NULL, NULL, N'1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Deployment History')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (455, 44, 17, 4, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you exposed to soot, ash, smoke, or fumes from the Gulf War oil fires?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (456, 44, 17, 4, N'Where did you spend <strong>most</strong> of your time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where did you spend most of your time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (457, 44, 17, 4, N'If you were at more than one base, where did you spend the <strong>second most</strong> amount of time during these dates?', N'text', N'', N'', 1, NULL, NULL, N'1.2.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If you were at more than one base, where did you spend the second most amount of time during these dates?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (458, 44, 17, 4, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Were you near a burn pit during these dates (on the base or close enough to the base for you to see the smoke)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (459, 44, 17, 4, N'Who ran this burn pit? (select all that apply)', N'multiSelect', N'', N'', 3, NULL, NULL, N'1.2.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Who ran this burn pit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (460, 44, 17, 4, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.2.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your duties during these dates include the burn pit (examples include trash burning, hauling trash to the burn pit, burn pit security, trash sorting at the burn pit)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (461, 44, 17, 4, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your <strong>work site or housing</strong>?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours did smoke or fumes from the burn pit enter your work site or housing?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (462, 44, 17, 4, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you outside or in an open tent or shelter? (for example a single wall tent with open seams or drafty ''B'' hut)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (463, 44, 17, 4, N'On a <strong>typical day</strong>, how many hours were you near (for example you could smell or see it) sewage ponds?', N'number', N'1', N'24', 1, NULL, NULL, N'1.2.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On a typical day, how many hours were you near (for example you could smell or see it) sewage ponds?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (464, 45, 17, 4, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Were you ever close enough to feel the blast from an IED (improvised explosive device) or other explosive device?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (465, 45, 17, 4, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you near heavy smoke from weapons, signal smoke, markers or other combat items?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (466, 45, 17, 4, N'In a typical month, how many days were you in convoy or other vehicle operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days were you in convoy or other vehicle operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (467, 45, 17, 4, N'In a typical month, how many days did you perform refueling operations?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform refueling operations?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (468, 45, 17, 4, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform aircraft, generator, or other large engine maintenance?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (469, 45, 17, 4, N'In a typical month, how many days did you perform construction duties?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform construction duties?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (470, 45, 17, 4, N'In a typical month, how many days did you perform pesticide duties for your unit?', N'number', N'1', N'31', 1, NULL, NULL, N'1.3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month, how many days did you perform pesticide duties for your unit?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (471, 46, 17, 4, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Did you do anything differently during your deployment(s), when you thought or were informed air quality was bad (for example during dust storms or heavy pollution days)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (472, 46, 17, 4, N'What did you do differently (select all that apply)?', N'multiSelect', N'', N'', 10, NULL, NULL, N'1.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What did you do differently?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (473, 46, 17, 4, N'In a typical month during your deployment(s), how many days did you experience dust storms?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In a typical month during your deployment(s), how many days did you experience dust storms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (474, 46, 17, 4, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you experience wheezing, difficulty breathing, an itchy or irritated nose, eyes or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (475, 46, 17, 4, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?', N'number', N'1', N'31', 1, NULL, NULL, N'1.4.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many days in an average month did you experience wheezing, difficulty breathing, an itchy or irritated eyes, nose, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (476, 46, 17, 4, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'1.4.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), did you seek medical care for wheezing, difficulty breathing, an itchy or irritated nose, eyes, or throat that you thought was the result of poor air quality?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (477, 47, 18, 4, N'How difficult is it to run or jog one mile on a level surface?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'How difficult is it to run or jog one mile on a level surface?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (478, 47, 18, 4, N'How difficult is it to walk on a level surface for one mile?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk on a level surface for one mile?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (479, 47, 18, 4, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk a 1/4 of a mile - about 3 city blocks?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (480, 47, 18, 4, N'How difficult is it to walk up a hill or incline?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up a hill or incline?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (481, 47, 18, 4, N'How difficult is it to walk up 10 steps or climb a flight of stairs?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.1.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How difficult is it to walk up 10 steps or climb a flight of stairs?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (482, 47, 18, 4, N'What condition or health problem causes you to have difficulty with these activities? (Check all that apply.)', N'multiSelect', N'', N'', 36, NULL, NULL, N'2.1.F', N'F', N'', NULL, NULL, N'', N'', N'NHIS Adult Health Status & Limitations starting with AHS.091_01.000', @UserName, @UserName, @Today, @Today, N'What condition or health problem causes you to have difficulty with these activities?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (483, 48, 18, 4, N'Respiratory Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.1', N'1', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Conditions ACN.031 series', @UserName, @UserName, @Today, @Today, N'Respiratory Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (484, 48, 18, 4, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.A', N'1.A', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you been told by a doctor or other health professional that you had Hay fever or allergies to pollen, dust, or animals?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (485, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had asthma?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.B', N'1.B', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.080_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had asthma?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (486, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had emphysema?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.C', N'1.C', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had emphysema?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (487, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic bronchitis?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.D', N'1.D', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic bronchitis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (488, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.E', N'1.E', N'1', NULL, NULL, N'', N'', N'NHIS Adult Conditions ACN.035 series', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had chronic obstructive pulmonary disease also called COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (489, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.F', N'1.F', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had some lung disease or condition other than asthma, emphysema, chronic bronchitis or COPD?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (490, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.G', N'1.G', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had constrictive bronchiolitis (CB)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (491, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.H', N'1.H', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had idiopathic pulmonary fibrosis (IPF)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (492, 48, 18, 4, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment? (che', N'multiSelect', N'', N'', 3, NULL, 30, N'2.2.1.I', N'1.I', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had asthma, emphysema, chronic bronchitis, COPD or some other lung disease by a doctor or other health care professional, were you told before, during, or after deployment? ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (493, 48, 18, 4, N'Did this lung disease get better, worse, or about the same during deployment?', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.J', N'1.J', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did this lung disease get better, worse, or about the same during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (494, 48, 18, 4, N'Do you currently have any of the following symptoms? (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.K', N'1.K', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have any of the following symptoms?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (495, 48, 18, 4, N'In the past 12 months did you have any of the following symptoms (Check all that apply)', N'multiSelect', N'', N'', 9, NULL, 30, N'2.2.1.L', N'1.L', N'1', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In the past 12 months did you have any of the following symptoms')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (496, 48, 18, 4, N'How would you rate your shortness of breath or breathlessness? (check the description/grade that applies to you.)  I''m:', N'multipleChoice', N'', N'', 1, NULL, 30, N'2.2.1.M', N'1.M', N'1', NULL, NULL, N'', N'', N'Medical Research Chronic (MRC) Breathlessness scale', @UserName, @UserName, @Today, @Today, N'How would you rate your shortness of breath or breathlessness? I''m:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (497, 48, 18, 4, N'Cardiovascular Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.2', N'2', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Cardiovascular Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (498, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.A', N'2.A', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had hypertension, also called high blood pressure?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (499, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had coronary artery disease?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.B', N'2.B', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had coronary artery disease?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (500, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had angina pectoris?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.C', N'2.C', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had angina pectoris?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (501, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.D', N'2.D', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart attack, also called myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (502, 48, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?', N'multipleChoice', N'', N'', 1, NULL, 44, N'2.2.2.E', N'2.E', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health care professional that you had a heart condition other than coronary artery disease or angina or myocardial infarction?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (503, 48, 18, 4, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ', N'multiSelect', N'', N'', 3, NULL, 44, N'2.2.2.F', N'2.F', N'2', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When you were told you had hypertension, coronary artery disease, angina pectoris, a heart attack, or some other heart condition by a doctor or health care professional, were you told before, during, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (504, 48, 18, 4, N'Other Conditions', N'recursive', N'', N'', NULL, NULL, NULL, N'2.2.3', N'3', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Conditions')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (505, 48, 18, 4, N'During the <strong>past 12 months</strong>, have you regularly had insomnia or trouble sleeping?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.A', N'3.A', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.250', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you regularly had insomnia or trouble sleeping?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (506, 48, 18, 4, N'During the <strong>past 12 months</strong>, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs or difficulties', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.B', N'3.B', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.130', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had Neurological problems? (Some examples of neurological problems may include numbness, tingling, or weakness in your arms or legs)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (507, 48, 18, 4, N'During the <strong>past 12 months</strong>, have you had problems of the immune system?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.C', N'3.C', N'3', NULL, NULL, N'', N'', N'NHIS ACN.125_00.100', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you had problems of the immune system?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (508, 48, 18, 4, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any kind of liver condition?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.D', N'3.D', N'3', NULL, NULL, N'', N'', N'NHIS ACN.201_05.000', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any kind of liver condition?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (509, 48, 18, 4, N'During the <strong>past 12 months</strong>, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness (examples include irritable bowel syndrome, chron', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.E', N'3.E', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During the past 12 months, have you been told by a doctor or other health professional that you had any chronic multi-symptom illness?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (510, 48, 18, 4, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition <strong>first</strong> occur before, during, or after deployment? (check all that apply)', N'multiSelect', N'', N'', 3, NULL, 51, N'2.2.3.F', N'3.F', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Did your, neurological or immune problems, chronic multi-symptom illness, or liver condition first occur before, during, or after deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (511, 48, 18, 4, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?', N'number', N'1', N'24', 1, NULL, 51, N'2.2.3.G', N'3.G', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'On average, how many hours of sleep do you get in a 24-hour period (round up 30 minutes or more to the next whole hour)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (512, 48, 18, 4, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you <strong>and</strong> what you know about yourself.', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.H', N'3.H', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Questions H and I are about snoring and breathing during sleep.  To answer these questions, please consider both what others have told you and what you know about yourself.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (513, 48, 18, 4, N'How often do you have times when you stop breathing during your sleep?', N'multipleChoice', N'', N'', 1, NULL, 51, N'2.2.3.I', N'3.I', N'3', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How often do you have times when you stop breathing during your sleep?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (514, 49, 18, 4, N'How tall are you without shoes?', N'radioCompoundSelect', N'', N'', 1, NULL, NULL, N'2.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How tall are you without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (515, 49, 18, 4, N'How much do you weigh without shoes?', N'number', N'0', N'1000', 1, NULL, NULL, N'2.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How much do you weigh without shoes?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (516, 50, 18, 4, N'Have you <strong>ever</strong> been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS  ACN.130_00.000', @UserName, @UserName, @Today, @Today, N'Have you ever been told by a doctor or other health professional that you had Cancer or a malignancy (tumor) of any kind?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (517, 50, 18, 4, N'What kind of cancer was it? ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.B', N'B', N'', NULL, NULL, N'TRUE', N'', N'', @UserName, @UserName, @Today, @Today, N'What kind of cancer was it? ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (518, 50, 18, 4, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (519, 50, 18, 4, N'If you were diagnosed with a second cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.D', N'D', N'', NULL, NULL, N'TRUE', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a second cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (520, 50, 18, 4, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (521, 50, 18, 4, N'If you were diagnosed with a third cancer, what kind of cancer was it?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.4.F', N'F', N'', NULL, NULL, N'TRUE', N'AND', N'', @UserName, @UserName, @Today, @Today, N'If you were diagnosed with a third cancer, what kind of cancer was it?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (522, 50, 18, 4, N'How old were you when this cancer was first diagnosed?', N'number', N'0', N'200', 1, NULL, NULL, N'2.4.G', N'G', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How old were you when this cancer was first diagnosed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (523, 51, 18, 4, N'Have you smoked at least 100 cigarettes in your entire life?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS Adult Health Behaviors: AHB.010_00.000', @UserName, @UserName, @Today, @Today, N'Have you smoked at least 100 cigarettes in your entire life?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (524, 51, 18, 4, N'How old were you when you first started to smoke fairly regularly?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How old were you when you first started to smoke fairly regularly?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (525, 51, 18, 4, N' Do you now smoke cigarettes every day, some days or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.C', N'C', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N' Do you now smoke cigarettes every day, some days or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (526, 51, 18, 4, N'How long has it been since you quit smoking?', N'number', N'0', N'99', 1, NULL, NULL, N'2.5.D', N'D', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How long has it been since you quit smoking?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (527, 51, 18, 4, N'On the average, how many cigarettes do you now smoke a day?', N'number', N'0', N'500', 1, NULL, NULL, N'2.5.E', N'E', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'On the average, how many cigarettes do you now smoke a day?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (528, 51, 18, 4, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever smoked tobacco products other than cigarettes even one time? (Such as cigars, pipes, water pipes or hookahs, small cigars that look like cigarettes, bidis, cigarillos, marijuana)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (529, 51, 18, 4, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now smoke tobacco products other than cigarettes every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (530, 51, 18, 4, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever used smokeless tobacco products even one time? (Such as chewing tobacco, snuff, dip, snus, or dissolvable tobacco)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (531, 51, 18, 4, N'Do you <strong>now</strong> use smokeless tobacco products every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you now use smokeless tobacco products every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (532, 51, 18, 4, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.5.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you exposed to second-hand smoke or environmental tobacco smoke every day, some days, rarely, or not at all?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (533, 52, 18, 4, N'Did you start smoking for the first time while being deployed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.A', N'A', NULL, NULL, NULL, NULL, NULL, N'DoD USAPHC DARE H2-5c', @UserName, @UserName, @Today, @Today, N'Did you start smoking for the first time while being deployed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (534, 52, 18, 4, N'How did deployment(s) change how much you smoked?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.6.B', N'B', N'', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'How did deployment(s) change how much you smoked?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (535, 53, 18, 4, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ', N'multipleChoice', N'', N'', 1, NULL, NULL, N'2.7.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'In the PAST YEAR, how often did you drink any type of alcoholic beverage. (Included are liquor such as whiskey or gin, beer, wine, wine coolers, and any other type of alcoholic beverage)? On average, ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (536, 54, 19, 4, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Compared to pre-deployment, would you say your overall health is better, worse, or about the same?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (537, 54, 19, 4, N'During your deployment(s), do you believe you were sick because of something you breathed?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'During your deployment(s), do you believe you were sick because of something you breathed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (538, 54, 19, 4, N'Do you <strong>currently</strong> have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you currently have a sickness or condition you think began or got worse because of something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (539, 54, 19, 4, N'When did the problem start?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'When did the problem start?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (540, 54, 19, 4, N'Please rate your concern that something you breathed during deployment <strong>has already affected</strong> your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment has already affected your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (541, 54, 19, 4, N'Please identify your biggest health concern that something you breathed during deployment <strong>has already affected</strong> your health:', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.F', N'F', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment has already affected your health:')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (542, 54, 19, 4, N'Have you discussed this concern with your health care provider, medical professional or team?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.G', N'G', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you discussed this concern with your health care provider, medical professional or team?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (543, 54, 19, 4, N'Are you concerned that <strong>in the future</strong> that your health will be affected by something you breathed during deployment(s)?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.H', N'H', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you concerned that in the future that your health will be affected by something you breathed during deployment(s)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (544, 54, 19, 4, N'Please rate your concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.I', N'I', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please rate your concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (545, 54, 19, 4, N'Please identify your biggest health concern that something you breathed during deployment will affect your <strong>future health</strong>.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.J', N'J', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please identify your biggest health concern that something you breathed during deployment will affect your future health.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (546, 54, 19, 4, N'Which exposure do you think has the <strong>biggest</strong> overall effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'3.K', N'K', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Which exposure do you think has the biggest overall effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (547, 55, 20, 4, N'Is the address above your current address?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'4.1.ZZ', N'ZZ', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Is the address above your current address?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (548, 55, 20, 4, N'What is your current address? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.A', N'A', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is your current address? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (549, 55, 20, 4, N'Country', N'country', N'', N'', 1, NULL, 95, N'4.1.A.1', N'A.1', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (550, 55, 20, 4, N'City Name', N'text', N'', N'', 1, NULL, 95, N'4.1.A.2', N'A.2', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (551, 55, 20, 4, N'State', N'state', N'', N'', 1, NULL, 95, N'4.1.A.3', N'A.3', N'A', NULL, NULL, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (552, 55, 20, 4, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 95, N'4.1.A.4', N'A.4', N'A', 5, 5, N'', N'AND', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (553, 55, 20, 4, N'How many years have you lived at your current address (listed above)?', N'number', N'0', N'99', 1, NULL, 95, N'4.1.A.5', N'A.5', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years have you lived at your current address (listed above)?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (554, 55, 20, 4, N'Do you live nine or more months of the year at the address listed above?', N'multipleChoice', N'', N'', 1, NULL, 95, N'4.1.A.6', N'A.6', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you live nine or more months of the year at the address listed above?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (555, 55, 20, 4, N'If not, indicate the other residence.', N'recursive', N'', N'', NULL, NULL, 95, N'4.1.A.7', N'A.7', N'A', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'If not, indicate the other residence.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (556, 55, 20, 4, N'Other Country', N'country', N'', N'', 1, NULL, NULL, N'4.1.A.7.a', N'A.7.a', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (557, 55, 20, 4, N'Other City Name', N'text', N'', N'', 1, NULL, NULL, N'4.1.A.7.b', N'A.7.b', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (558, 55, 20, 4, N'Other state', N'state', N'', N'', 1, NULL, NULL, N'4.1.A.7.c', N'A.7.c', N'7', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other state')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (559, 55, 20, 4, N'Other zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, NULL, N'4.1.A.7.d', N'A.7.d', N'7', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Other zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (560, 55, 20, 4, N'Where have you lived the longest? Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Where have you lived the longest? Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (561, 55, 20, 4, N'The address where I lived the longest is the same as my current address', N'multipleChoice', N'', N'', 1, NULL, 107, N'4.1.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'The address where I lived the longest is the same as my current address')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (562, 55, 20, 4, N'Country', N'country', N'', N'', 1, NULL, 107, N'4.1.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (563, 55, 20, 4, N'City Name', N'text', N'', N'', 1, NULL, 107, N'4.1.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (564, 55, 20, 4, N'State', N'state', N'', N'', 1, NULL, 107, N'4.1.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (565, 55, 20, 4, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 107, N'4.1.B.5', N'B.5', N'B', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (566, 55, 20, 4, N'Indicate the approximate year you moved to this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.6', N'B.6', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved to this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (567, 55, 20, 4, N'Indicate the approximate year you moved out of this address.', N'number', N'1900', N'2100', 1, NULL, 107, N'4.1.B.7', N'B.7', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate year you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (568, 55, 20, 4, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.', N'recursive', N'', N'', NULL, NULL, NULL, N'4.1.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Please provide the address where you lived the longest before age 13. Please include the city, state, zip code, and country.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (569, 55, 20, 4, N'Country', N'country', N'', N'', 1, NULL, 115, N'4.1.C.1', N'C.1', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Country')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (570, 55, 20, 4, N'City Name', N'text', N'', N'', 1, NULL, 115, N'4.1.C.2', N'C.2', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'City Name')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (571, 55, 20, 4, N'State', N'state', N'', N'', 1, NULL, 115, N'4.1.C.3', N'C.3', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'State')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (572, 55, 20, 4, N'Zip code (if known - 5 digit number)', N'number', N'1', N'99999', 1, NULL, 115, N'4.1.C.4', N'C.4', N'C', 5, 5, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Zip code (if known - 5 digit number)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (573, 55, 20, 4, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.5', N'C.5', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved to this address. (Enter 0 if you lived there before age 1)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (574, 55, 20, 4, N'Indicate the approximate age you moved out of this address.', N'number', N'0', N'200', 1, NULL, 115, N'4.1.C.6', N'C.6', N'C', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Indicate the approximate age you moved out of this address.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (575, 56, 21, 4, N'Which of the following were you doing last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Which of the following were you doing last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (576, 56, 21, 4, N'What is the main reason you did not work last week/have a job or business last week?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.1.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'What is the main reason you did not work last week/have a job or business last week?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (577, 57, 21, 4, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). <strong>Do not include your occupation during military service.</strong>  If your ', N'text', N'', N'', 1, NULL, NULL, N'5.2.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes your main occupation (the civilian job youve held the longest). Do not include your occupation during military service. ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (578, 57, 21, 4, N'Total years in this non-military job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, NULL, N'5.2.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this non-military job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (579, 58, 21, 4, N'Have you ever worked for a year or more in any dusty job <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.3.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked for a year or more in any dusty job outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (580, 58, 21, 4, N'For the job with the biggest dust exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.3.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest dust exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (581, 58, 21, 4, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 127, N'5.3.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupation category that best describes the job with the longest dust exposure.  If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (582, 58, 21, 4, N'In this job, what were the most common kinds of dust to which you were exposed?', N'multiSelect', N'', N'', 20, NULL, 127, N'5.3.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of dust to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (583, 58, 21, 4, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 127, N'5.3.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (584, 58, 21, 4, N'Are you working in this dusty job now?', N'multipleChoice', N'', N'', 1, NULL, 127, N'5.3.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this dusty job now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (585, 59, 21, 4, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work <strong>outside the military</strong>?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.4.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever been exposed to gas, smoke, chemical vapors or fumes in your work outside the military?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (586, 59, 21, 4, N'For the job with the biggest gas, smoke, vapor or fume exposure: ', N'recursive', N'', N'', NULL, NULL, NULL, N'5.4.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'For the job with the biggest gas, smoke, vapor or fume exposure: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (587, 59, 21, 4, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ', N'text', N'', N'', 1, NULL, 133, N'5.4.B.1', N'B.1', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the occupational category that best describes the job with the longest gas, smoke, chemical vapor, or fume exposures. If your occupation is not included, select other occupation: ')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (588, 59, 21, 4, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?', N'multiSelect', N'', N'', 13, NULL, 133, N'5.4.B.2', N'B.2', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'In this job, what were the most common kinds of gas, smoke, or chemical vapors or fumes to which you were exposed?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (589, 59, 21, 4, N'Total years in this job {099} years (enter 0 if less than one year).', N'number', N'0', N'99', 1, NULL, 133, N'5.4.B.3', N'B.3', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Total years in this job {099} years (enter 0 if less than one year).')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (590, 59, 21, 4, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?', N'multipleChoice', N'', N'', 1, NULL, 133, N'5.4.B.4', N'B.4', N'B', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in this job with gas, smoke, chemical vapors, or fumes now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (591, 60, 21, 4, N'Have you ever worked in a job with asbestos exposure, including military service?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Have you ever worked in a job with asbestos exposure, including military service?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (592, 60, 21, 4, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Select the type(s) of asbestos exposure that describe(s) how you were exposed')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (593, 60, 21, 4, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)', N'number', N'0', N'99', 1, NULL, NULL, N'5.5.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many years did you work in a job with asbestos exposure? (enter 0 if less than one year)')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (594, 60, 21, 4, N'Are you working in a job with asbestos exposure now?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'5.5.D', N'D', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Are you working in a job with asbestos exposure now?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (595, 61, 22, 4, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'Are there any traditional farm animals that live on your land or that you visit on a regular basis?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (596, 61, 22, 4, N'Have you ever removed mold in your home because of its effect on your health?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever removed mold in your home because of its effect on your health?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (597, 61, 22, 4, N'Have you ever lived in a home that had elevated radon levels?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'6.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Have you ever lived in a home that had elevated radon levels?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (598, 61, 22, 4, N'Please select from the list below any hobbies you participate in.', N'multiSelect', N'', N'', 7, NULL, NULL, N'6.D', N'D', N'', NULL, NULL, N'', N'', N'DoD USAPHC DARE questionnaire, page 14, section G', @UserName, @UserName, @Today, @Today, N'Please select from the list below any hobbies you participate in.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (599, 61, 22, 4, N'How many total hours a week, on average, do you participate in all the above hobbies combined?', N'number', N'0', N'168', 1, NULL, NULL, N'6.E', N'E', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'How many total hours a week, on average, do you participate in all the above hobbies combined?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (600, 62, 23, 4, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.A', N'A', NULL, NULL, NULL, NULL, NULL, N'NHIS: Adult Access to Health Care & Utilization, AAU.305_00.000', @UserName, @UserName, @Today, @Today, N'About how long has it been since you last saw or talked to a doctor or other health care professional about your own health?  Include doctors seen while a patient in a hospital.')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (601, 62, 23, 4, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'7.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you wish to see a DoD or VA health care provider to discuss your health concerns related to airborne hazards during deployment?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (602, 63, 24, 4, N'How do you prefer to receive updated information on burn pits and other airborne exposures?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.A', N'A', NULL, NULL, NULL, NULL, NULL, NULL, @UserName, @UserName, @Today, @Today, N'How do you prefer to receive updated information on burn pits and other airborne exposures?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (603, 63, 24, 4, N'Do you use the internet?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.B', N'B', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you use the internet?')
    INSERT [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [TEXT], [TYPE], [MIN], [MAX], [MAX_CHOICES], [STD_CONCEPT_ID], [PARENT_ID], [FORM_QUESTION_UNIQUE_ID], [BRP_FORM_QUESTION_ID], [BRP_PARENT_QUESTION_ID], [MAX_LENGTH], [MIN_LENGTH], [POST_REQ_TRIGGER_ONCE], [PRE_REQ_OPERATOR], [SOURCE_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [SHORT_TEXT]) VALUES (604, 63, 24, 4, N'Do you send or receive emails?', N'multipleChoice', N'', N'', 1, NULL, NULL, N'8.C', N'C', N'', NULL, NULL, N'', N'', N'', @UserName, @UserName, @Today, @Today, N'Do you send or receive emails?')
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_QUESTION] OFF
    /****** Object:  Table [AHOBPR].[STD_FORM_ANSWER]    Script Date: 01/20/2015 11:39:07 ******/
    SET IDENTITY_INSERT [AHOBPR].[STD_FORM_ANSWER] ON
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, 1, 1, 1, 1, 1, N'[deployment history table]', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, 2, 2, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, 2, 2, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, 2, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, 2, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, 3, 2, 1, 1, 1, N'', 1, N'Enter base name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, 3, 2, 1, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, 3, 2, 1, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, 4, 2, 1, 1, 1, N'', 1, N'Enter base name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, 4, 2, 1, 1, 2, N'I was not at any other bases', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, 4, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, 4, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, 5, 2, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, 5, 2, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, 5, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, 5, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, 6, 2, 1, 1, 1, N'U.S. forces or Contractor', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, 6, 2, 1, 1, 2, N'Coalition forces', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (19, 6, 2, 1, 1, 3, N'Host nation', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (20, 6, 2, 1, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, 6, 2, 1, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, 7, 2, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, 7, 2, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (24, 7, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (25, 7, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (26, 8, 2, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (27, 8, 2, 1, 1, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (28, 8, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (29, 8, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (30, 9, 2, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (31, 9, 2, 1, 1, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (32, 9, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (33, 9, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (34, 10, 2, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (35, 10, 2, 1, 1, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (36, 10, 2, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (37, 10, 2, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (38, 11, 3, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (39, 11, 3, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (40, 11, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (41, 11, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (42, 12, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (43, 12, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (44, 12, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (45, 12, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (46, 13, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (47, 13, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (48, 13, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (49, 13, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (50, 14, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (51, 14, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (52, 14, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (53, 14, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (54, 15, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (55, 15, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (56, 15, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (57, 15, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (58, 16, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (59, 16, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (60, 16, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (61, 16, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (62, 17, 3, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (63, 17, 3, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (64, 17, 3, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (65, 17, 3, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (66, 18, 4, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (67, 18, 4, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (68, 18, 4, 1, 1, 3, N'Never thought of this', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (69, 18, 4, 1, 1, 4, N'I was not informed or aware of bad air quality', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (70, 18, 4, 1, 1, 5, N'I do not wish to answer', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (71, 18, 4, 1, 1, 6, N'Don''t know', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (72, 19, 4, 1, 1, 1, N'Wore a mask, cravat, or bandana over your mouth or nose', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (73, 19, 4, 1, 1, 2, N'Spent less time outdoors', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (74, 19, 4, 1, 1, 3, N'Did less strenuous activities (i.e. avoided physical training (PT))', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (75, 19, 4, 1, 1, 4, N'Took medication', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (76, 19, 4, 1, 1, 5, N'Closed windows of your sleeping quarters', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (77, 19, 4, 1, 1, 6, N'Spent less time in convoy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (78, 19, 4, 1, 1, 7, N'Canceled outdoor activities', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (79, 19, 4, 1, 1, 8, N'Exercised indoors instead of outdoors', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (80, 19, 4, 1, 1, 9, N'Use or change air filter/air cleaner', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (81, 19, 4, 1, 1, 10, N'Other', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (82, 19, 4, 1, 1, 11, N'I did not (or could not) do anything differently', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (83, 19, 4, 1, 1, 12, N'I do not wish to answer', 0, N'', 16, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (84, 20, 4, 1, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (85, 20, 4, 1, 1, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (86, 20, 4, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (87, 20, 4, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (88, 21, 4, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (89, 21, 4, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (90, 21, 4, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (91, 21, 4, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (92, 22, 4, 1, 1, 2, N'Never', 0, N'', NULL, 0, N'2', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (93, 22, 4, 1, 1, 1, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'1', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (94, 22, 4, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (95, 22, 4, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (96, 23, 4, 1, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (97, 23, 4, 1, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (98, 23, 4, 1, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (99, 23, 4, 1, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (100, 24, 5, 2, 1, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (101, 24, 5, 2, 1, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (102, 24, 5, 2, 1, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (103, 24, 5, 2, 1, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (104, 24, 5, 2, 1, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (105, 24, 5, 2, 1, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (106, 24, 5, 2, 1, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (107, 24, 5, 2, 1, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (108, 25, 5, 2, 1, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (109, 25, 5, 2, 1, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (110, 25, 5, 2, 1, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (111, 25, 5, 2, 1, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (112, 25, 5, 2, 1, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (113, 25, 5, 2, 1, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (114, 25, 5, 2, 1, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (115, 25, 5, 2, 1, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (116, 26, 5, 2, 1, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (117, 26, 5, 2, 1, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (118, 26, 5, 2, 1, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (119, 26, 5, 2, 1, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (120, 26, 5, 2, 1, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (121, 26, 5, 2, 1, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (122, 26, 5, 2, 1, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (123, 26, 5, 2, 1, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (124, 27, 5, 2, 1, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (125, 27, 5, 2, 1, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (126, 27, 5, 2, 1, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (127, 27, 5, 2, 1, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (128, 27, 5, 2, 1, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (129, 27, 5, 2, 1, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (130, 27, 5, 2, 1, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (131, 27, 5, 2, 1, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (132, 28, 5, 2, 1, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (133, 28, 5, 2, 1, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (134, 28, 5, 2, 1, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (135, 28, 5, 2, 1, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (136, 28, 5, 2, 1, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (137, 28, 5, 2, 1, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (138, 28, 5, 2, 1, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (139, 28, 5, 2, 1, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (140, 29, 5, 2, 1, 1, N'Arthritis/rheumatism', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (141, 29, 5, 2, 1, 2, N'Back or neck problem', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (142, 29, 5, 2, 1, 3, N'Benign Tumors, Cysts', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (143, 29, 5, 2, 1, 4, N'Birth defect', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (144, 29, 5, 2, 1, 5, N'Brain injury, (for example, Traumatic Brain Injury/TBI, Intellectual disability)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (145, 29, 5, 2, 1, 6, N'Cancer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (146, 29, 5, 2, 1, 7, N'Circulation problems (including blood clots)', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (147, 29, 5, 2, 1, 8, N'Depression/anxiety/emotional problem', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (148, 29, 5, 2, 1, 9, N'Diabetes', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (149, 29, 5, 2, 1, 10, N'Epilepsy, seizures', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (150, 29, 5, 2, 1, 11, N'Fibromyalgia, lupus', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (151, 29, 5, 2, 1, 12, N'Fracture, bone/joint injury', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (152, 29, 5, 2, 1, 13, N'Hearing problem', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (153, 29, 5, 2, 1, 14, N'Heart problem', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (154, 29, 5, 2, 1, 15, N'Hernia', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (155, 29, 5, 2, 1, 16, N'Hypertension/high blood pressure', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (156, 29, 5, 2, 1, 17, N'Kidney, bladder or renal problems', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (157, 29, 5, 2, 1, 18, N'Knee problems (not arthritis, not joint injury)', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (158, 29, 5, 2, 1, 19, N'Lung/breathing problem (for example, asthma and emphysema)', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (159, 29, 5, 2, 1, 20, N'Migraine headaches (not just headaches)', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (160, 29, 5, 2, 1, 21, N'Missing limbs (fingers, toes or digits), amputee', 0, N'', NULL, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (161, 29, 5, 2, 1, 22, N'Multiple Sclerosis (MS), Muscular Dystrophy (MD)', 0, N'', NULL, 0, N'22', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (162, 29, 5, 2, 1, 23, N'Other developmental problem (for example, cerebral palsy)', 0, N'', NULL, 0, N'23', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (163, 29, 5, 2, 1, 24, N'Other injury', 0, N'', NULL, 0, N'24', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (164, 29, 5, 2, 1, 25, N'Other nerve damage, including carpal tunnel syndrome', 0, N'', NULL, 0, N'25', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (165, 29, 5, 2, 1, 26, N'Osteoporosis, tendinitis', 0, N'', NULL, 0, N'26', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (166, 29, 5, 2, 1, 27, N'Parkinson''s disease, other tremors', 0, N'', NULL, 0, N'27', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (167, 29, 5, 2, 1, 28, N'Polio (myelitis), paralysis, para/quadriplegia', 0, N'', NULL, 0, N'28', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (168, 29, 5, 2, 1, 29, N'Senility', 0, N'', NULL, 0, N'29', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (169, 29, 5, 2, 1, 30, N'Stroke problem', 0, N'', NULL, 0, N'30', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (170, 29, 5, 2, 1, 31, N'Thyroid problems, Grave''s disease, gout', 0, N'', NULL, 0, N'31', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (171, 29, 5, 2, 1, 32, N'Ulcer', 0, N'', NULL, 0, N'32', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (172, 29, 5, 2, 1, 33, N'Varicose veins, hemorrhoids', 0, N'', NULL, 0, N'33', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (173, 29, 5, 2, 1, 34, N'Vision/problem seeing', 0, N'', NULL, 0, N'34', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (174, 29, 5, 2, 1, 35, N'Weight problem', 0, N'', NULL, 0, N'35', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (175, 29, 5, 2, 1, 36, N'', 1, N'Other impairment/problem (Specify one).', 18, 0, N'36', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (176, 29, 5, 2, 1, 37, N'I do not wish to answer', 0, N'', 16, 0, N'37', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (177, 29, 5, 2, 1, 38, N'Don''t know/Not sure', 0, N'', 17, 0, N'38', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (178, 30, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (179, 31, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (180, 31, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (181, 31, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (182, 31, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (183, 32, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (184, 32, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (185, 32, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (186, 32, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (187, 33, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (188, 33, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (189, 33, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (190, 33, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (191, 34, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (192, 34, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (193, 34, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (194, 34, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (195, 35, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (196, 35, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (197, 35, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (198, 35, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (199, 36, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (200, 36, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (201, 36, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (202, 36, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (203, 37, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (204, 37, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (205, 37, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (206, 37, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (207, 38, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (208, 38, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (209, 38, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (210, 38, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (211, 39, 6, 2, 1, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (212, 39, 6, 2, 1, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (213, 39, 6, 2, 1, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (214, 39, 6, 2, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (215, 39, 6, 2, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (216, 40, 6, 2, 1, 1, N'Better', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (217, 40, 6, 2, 1, 2, N'Worse', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (218, 40, 6, 2, 1, 3, N'About the same', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (219, 40, 6, 2, 1, 4, N'Not applicable', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (220, 40, 6, 2, 1, 5, N'I do not wish to answer', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (221, 40, 6, 2, 1, 6, N'Don''t know', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (222, 41, 6, 2, 1, 1, N'Cough for more than 3 weeks', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (223, 41, 6, 2, 1, 2, N'Sputum or phlegm production for more than 3 weeks', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (224, 41, 6, 2, 1, 3, N'Wheezing or whistling in the chest', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (225, 41, 6, 2, 1, 4, N'Shortness of breath; breathlessness', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (226, 41, 6, 2, 1, 5, N'Decreased ability to exercise', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (227, 41, 6, 2, 1, 6, N'Hay fever or other respiratory allergy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (228, 41, 6, 2, 1, 7, N'Sore throat, hoarseness, change in voice', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (229, 41, 6, 2, 1, 8, N'Chest pain, chest discomfort or chest tightness', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (230, 41, 6, 2, 1, 9, N'Chronic sinus infection/sinusitis', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (231, 41, 6, 2, 1, 10, N'I do not wish to answer', 0, N'', 16, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (232, 41, 6, 2, 1, 11, N'I do not have these symptoms', 0, N'', 17, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (233, 42, 6, 2, 1, 1, N'Cough for more than 3 weeks', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (234, 42, 6, 2, 1, 2, N'Sputum or phlegm production for more than 3 weeks', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (235, 42, 6, 2, 1, 3, N'Wheezing or whistling in the chest', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (236, 42, 6, 2, 1, 4, N'Shortness of breath; breathlessness', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (237, 42, 6, 2, 1, 5, N'Decreased ability to exercise', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (238, 42, 6, 2, 1, 6, N'Hay fever or other respiratory allergy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (239, 42, 6, 2, 1, 7, N'Sore throat, hoarseness, change in voice', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (240, 42, 6, 2, 1, 8, N'Chest pain, chest discomfort or chest tightness', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (241, 42, 6, 2, 1, 9, N'Chronic sinus infection/sinusitis', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (242, 42, 6, 2, 1, 10, N'I do not wish to answer', 0, N'', 16, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (243, 42, 6, 2, 1, 11, N'I do not have these symptoms', 0, N'', 17, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (244, 43, 6, 2, 1, 1, N'Not troubled by breathlessness except on strenuous exercise', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (245, 43, 6, 2, 1, 2, N'Short of breath when hurrying on the level or walking up a slight hill', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (246, 43, 6, 2, 1, 3, N'Walking slower than most people on level ground, stop after one mile, or stop after 15 minutes walking at my own pace', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (247, 43, 6, 2, 1, 4, N'Stopping for breath after walking about 100 yards or after a few minutes on level ground', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (248, 43, 6, 2, 1, 5, N'Too breathless to leave the house, or breathless when dressing or undressing', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (249, 43, 6, 2, 1, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (250, 44, 6, 2, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (251, 45, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (252, 45, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (253, 45, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (254, 45, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (255, 46, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (256, 46, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (257, 46, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (258, 46, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (259, 47, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (260, 47, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (261, 47, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (262, 47, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (263, 48, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (264, 48, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (265, 48, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (266, 48, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (267, 49, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (268, 49, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (269, 49, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (270, 49, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (271, 50, 6, 2, 1, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (272, 50, 6, 2, 1, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (273, 50, 6, 2, 1, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (274, 50, 6, 2, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (275, 50, 6, 2, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (276, 51, 6, 2, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (277, 52, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (278, 52, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (279, 52, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (280, 52, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (281, 53, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (282, 53, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (283, 53, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (284, 53, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (285, 54, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (286, 54, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (287, 54, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (288, 54, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (289, 55, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (290, 55, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (291, 55, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (292, 55, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (293, 56, 6, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (294, 56, 6, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (295, 56, 6, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (296, 56, 6, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (297, 57, 6, 2, 1, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (298, 57, 6, 2, 1, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (299, 57, 6, 2, 1, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (300, 57, 6, 2, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (301, 57, 6, 2, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (302, 58, 6, 2, 1, 1, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (303, 58, 6, 2, 1, 2, N'I do not wish to answer', 0, N'', 16, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (304, 58, 6, 2, 1, 3, N'Don''t know', 0, N'', 17, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (305, 59, 6, 2, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (306, 59, 6, 2, 1, 2, N'Rarely - less than one night a week', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (307, 59, 6, 2, 1, 3, N'Sometimes - 1 or 2 nights a week', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (308, 59, 6, 2, 1, 4, N'Frequently - 3 to 5 nights a week', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (309, 59, 6, 2, 1, 5, N'Always or almost always - 6 or 7 nights a week', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (310, 59, 6, 2, 1, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (311, 59, 6, 2, 1, 7, N'Don''t know', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (312, 60, 6, 2, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (313, 60, 6, 2, 1, 2, N'Rarely - less than one night a week', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (314, 60, 6, 2, 1, 3, N'Sometimes - 1 or 2 nights a week', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (315, 60, 6, 2, 1, 4, N'Frequently - 3 to 5 nights a week', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (316, 60, 6, 2, 1, 5, N'Always or almost always - 6 or 7 nights a week', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (317, 60, 6, 2, 1, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (318, 60, 6, 2, 1, 7, N'Don''t know', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (319, 61, 7, 2, 1, 1, N'', 1, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (320, 61, 7, 2, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (321, 61, 7, 2, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (322, 62, 7, 2, 1, 1, N'', 1, N'Enter pounds.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (323, 62, 7, 2, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (324, 62, 7, 2, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (325, 63, 8, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (326, 63, 8, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (327, 63, 8, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (328, 63, 8, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (329, 64, 8, 2, 1, 1, N'Bladder', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (330, 64, 8, 2, 1, 2, N'Blood', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (331, 64, 8, 2, 1, 3, N'Bone', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (332, 64, 8, 2, 1, 4, N'Brain', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (333, 64, 8, 2, 1, 5, N'Breast', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (334, 64, 8, 2, 1, 6, N'Cervix', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (335, 64, 8, 2, 1, 7, N'Colon', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (336, 64, 8, 2, 1, 8, N'Esophagus', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (337, 64, 8, 2, 1, 9, N'Gallbladder', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (338, 64, 8, 2, 1, 10, N'Kidney', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (339, 64, 8, 2, 1, 11, N'Larynx-windpipe', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (340, 64, 8, 2, 1, 12, N'Leukemia', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (341, 64, 8, 2, 1, 13, N'Liver', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (342, 64, 8, 2, 1, 14, N'Lung', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (343, 64, 8, 2, 1, 15, N'Lymphoma', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (344, 64, 8, 2, 1, 16, N'Melanoma', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (345, 64, 8, 2, 1, 17, N'Mouth/tongue/lip', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (346, 64, 8, 2, 1, 18, N'Ovary', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (347, 64, 8, 2, 1, 19, N'Pancreas', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (348, 64, 8, 2, 1, 20, N'Prostate', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (349, 64, 8, 2, 1, 21, N'Rectum', 0, N'', NULL, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (350, 64, 8, 2, 1, 22, N'Skin (non-melanoma)', 0, N'', NULL, 0, N'22', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (351, 64, 8, 2, 1, 23, N'Skin (Dont Know what kind)', 0, N'', NULL, 0, N'23', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (352, 64, 8, 2, 1, 24, N'Soft tissue (muscle or fat)', 0, N'', NULL, 0, N'24', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (353, 64, 8, 2, 1, 25, N'Stomach', 0, N'', NULL, 0, N'25', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (354, 64, 8, 2, 1, 26, N'Testis', 0, N'', NULL, 0, N'26', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (355, 64, 8, 2, 1, 27, N'Throat-pharynx', 0, N'', NULL, 0, N'27', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (356, 64, 8, 2, 1, 28, N'Thyroid', 0, N'', NULL, 0, N'28', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (357, 64, 8, 2, 1, 29, N'Uterus', 0, N'', NULL, 0, N'29', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (358, 64, 8, 2, 1, 30, N'Other', 0, N'', NULL, 0, N'30', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (359, 64, 8, 2, 1, 31, N'None', 0, N'', NULL, 0, N'31', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (360, 64, 8, 2, 1, 32, N'I do not wish to answer', 0, N'', 16, 0, N'32', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (361, 64, 8, 2, 1, 32, N'Don''t know', 0, N'', 17, 0, N'33', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (362, 65, 8, 2, 1, 1, N'', 1, N'Enter age when diagnosis was detected.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (363, 65, 8, 2, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (364, 65, 8, 2, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (365, 66, 8, 2, 1, 1, N'Bladder', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (366, 66, 8, 2, 1, 2, N'Blood', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (367, 66, 8, 2, 1, 3, N'Bone', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (368, 66, 8, 2, 1, 4, N'Brain', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (369, 66, 8, 2, 1, 5, N'Breast', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (370, 66, 8, 2, 1, 6, N'Cervix', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (371, 66, 8, 2, 1, 7, N'Colon', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (372, 66, 8, 2, 1, 8, N'Esophagus', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (373, 66, 8, 2, 1, 9, N'Gallbladder', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (374, 66, 8, 2, 1, 10, N'Kidney', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (375, 66, 8, 2, 1, 11, N'Larynx-windpipe', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (376, 66, 8, 2, 1, 12, N'Leukemia', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (377, 66, 8, 2, 1, 13, N'Liver', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (378, 66, 8, 2, 1, 14, N'Lung', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (379, 66, 8, 2, 1, 15, N'Lymphoma', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (380, 66, 8, 2, 1, 16, N'Melanoma', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (381, 66, 8, 2, 1, 17, N'Mouth/tongue/lip', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (382, 66, 8, 2, 1, 18, N'Ovary', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (383, 66, 8, 2, 1, 19, N'Pancreas', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (384, 66, 8, 2, 1, 20, N'Prostate', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (385, 66, 8, 2, 1, 21, N'Rectum', 0, N'', NULL, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (386, 66, 8, 2, 1, 22, N'Skin (non-melanoma)', 0, N'', NULL, 0, N'22', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (387, 66, 8, 2, 1, 23, N'Skin (Dont Know what kind)', 0, N'', NULL, 0, N'23', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (388, 66, 8, 2, 1, 24, N'Soft tissue (muscle or fat)', 0, N'', NULL, 0, N'24', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (389, 66, 8, 2, 1, 25, N'Stomach', 0, N'', NULL, 0, N'25', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (390, 66, 8, 2, 1, 26, N'Testis', 0, N'', NULL, 0, N'26', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (391, 66, 8, 2, 1, 27, N'Throat-pharynx', 0, N'', NULL, 0, N'27', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (392, 66, 8, 2, 1, 28, N'Thyroid', 0, N'', NULL, 0, N'28', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (393, 66, 8, 2, 1, 29, N'Uterus', 0, N'', NULL, 0, N'29', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (394, 66, 8, 2, 1, 30, N'Other', 0, N'', NULL, 0, N'30', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (395, 66, 8, 2, 1, 31, N'None', 0, N'', NULL, 0, N'31', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (396, 66, 8, 2, 1, 32, N'I do not wish to answer', 0, N'', 16, 0, N'32', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (397, 66, 8, 2, 1, 32, N'Don''t know', 0, N'', 17, 0, N'33', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (398, 67, 8, 2, 1, 1, N'', 1, N'Enter age when diagnosis was detected.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (399, 67, 8, 2, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (400, 67, 8, 2, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (401, 68, 8, 2, 1, 1, N'Bladder', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (402, 68, 8, 2, 1, 2, N'Blood', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (403, 68, 8, 2, 1, 3, N'Bone', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (404, 68, 8, 2, 1, 4, N'Brain', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (405, 68, 8, 2, 1, 5, N'Breast', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (406, 68, 8, 2, 1, 6, N'Cervix', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (407, 68, 8, 2, 1, 7, N'Colon', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (408, 68, 8, 2, 1, 8, N'Esophagus', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (409, 68, 8, 2, 1, 9, N'Gallbladder', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (410, 68, 8, 2, 1, 10, N'Kidney', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (411, 68, 8, 2, 1, 11, N'Larynx-windpipe', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (412, 68, 8, 2, 1, 12, N'Leukemia', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (413, 68, 8, 2, 1, 13, N'Liver', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (414, 68, 8, 2, 1, 14, N'Lung', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (415, 68, 8, 2, 1, 15, N'Lymphoma', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (416, 68, 8, 2, 1, 16, N'Melanoma', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (417, 68, 8, 2, 1, 17, N'Mouth/tongue/lip', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (418, 68, 8, 2, 1, 18, N'Ovary', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (419, 68, 8, 2, 1, 19, N'Pancreas', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (420, 68, 8, 2, 1, 20, N'Prostate', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (421, 68, 8, 2, 1, 21, N'Rectum', 0, N'', NULL, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (422, 68, 8, 2, 1, 22, N'Skin (non-melanoma)', 0, N'', NULL, 0, N'22', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (423, 68, 8, 2, 1, 23, N'Skin (Dont Know what kind)', 0, N'', NULL, 0, N'23', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (424, 68, 8, 2, 1, 24, N'Soft tissue (muscle or fat)', 0, N'', NULL, 0, N'24', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (425, 68, 8, 2, 1, 25, N'Stomach', 0, N'', NULL, 0, N'25', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (426, 68, 8, 2, 1, 26, N'Testis', 0, N'', NULL, 0, N'26', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (427, 68, 8, 2, 1, 27, N'Throat-pharynx', 0, N'', NULL, 0, N'27', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (428, 68, 8, 2, 1, 28, N'Thyroid', 0, N'', NULL, 0, N'28', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (429, 68, 8, 2, 1, 29, N'Uterus', 0, N'', NULL, 0, N'29', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (430, 68, 8, 2, 1, 30, N'Other', 0, N'', NULL, 0, N'30', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (431, 68, 8, 2, 1, 31, N'None', 0, N'', NULL, 0, N'31', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (432, 68, 8, 2, 1, 32, N'I do not wish to answer', 0, N'', 16, 0, N'32', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (433, 68, 8, 2, 1, 32, N'Don''t know', 0, N'', 17, 0, N'33', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (434, 69, 8, 2, 1, 1, N'', 1, N'Enter age when diagnosis was detected.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (435, 69, 8, 2, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (436, 69, 8, 2, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (437, 70, 9, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (438, 70, 9, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (439, 70, 9, 2, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (440, 70, 9, 2, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (441, 71, 9, 2, 1, 1, N'', 1, N'Enter age in years when started smoking.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (442, 71, 9, 2, 1, 2, N'Never smoked regularly', 0, N'', 15, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (443, 71, 9, 2, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (444, 71, 9, 2, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (445, 72, 9, 2, 1, 1, N'Everyday', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (446, 72, 9, 2, 1, 2, N'Some days', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (447, 72, 9, 2, 1, 3, N'Not at all', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (448, 72, 9, 2, 1, 4, N'I do not wish to answer', 0, N'', 16, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (449, 72, 9, 2, 1, 5, N'Don''t know', 0, N'', 17, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (450, 73, 9, 2, 1, 1, N'', 1, N'Enter years since quit smoking.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (451, 73, 9, 2, 1, 2, N'I do not wish to answer', 0, N'', 16, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (452, 73, 9, 2, 1, 3, N'Don''t know', 0, N'', 17, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (453, 74, 9, 2, 1, 1, N'', 1, N'Enter number of cigarettes per day.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (454, 74, 9, 2, 1, 2, N'I do not wish to answer', 0, N'', 16, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (455, 74, 9, 2, 1, 3, N'Don''t know', 0, N'', 17, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (456, 75, 9, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (457, 75, 9, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (458, 75, 9, 2, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (459, 75, 9, 2, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (460, 76, 9, 2, 1, 1, N'Every day', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (461, 76, 9, 2, 1, 2, N'Some days', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (462, 76, 9, 2, 1, 3, N'Rarely', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (463, 76, 9, 2, 1, 4, N'Not at all', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (464, 76, 9, 2, 1, 5, N'I do not wish to answer', 0, N'', 16, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (465, 76, 9, 2, 1, 6, N'Don''t know', 0, N'', 17, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (466, 77, 9, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (467, 77, 9, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (468, 77, 9, 2, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (469, 77, 9, 2, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (470, 78, 9, 2, 1, 1, N'Every day', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (471, 78, 9, 2, 1, 2, N'Some days', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (472, 78, 9, 2, 1, 3, N'Rarely', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (473, 78, 9, 2, 1, 4, N'Not at all', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (474, 78, 9, 2, 1, 5, N'I do not wish to answer', 0, N'', 16, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (475, 78, 9, 2, 1, 6, N'Don''t know', 0, N'', 17, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (476, 79, 9, 2, 1, 1, N'Everyday', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (477, 79, 9, 2, 1, 2, N'Some days', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (478, 79, 9, 2, 1, 3, N'Rarely', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (479, 79, 9, 2, 1, 4, N'Not at all', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (480, 79, 9, 2, 1, 5, N'I do not wish to answer', 0, N'', 16, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (481, 79, 9, 2, 1, 6, N'Don''t know', 0, N'', 17, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (482, 80, 10, 2, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (483, 80, 10, 2, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (484, 80, 10, 2, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (485, 80, 10, 2, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (486, 81, 10, 2, 1, 1, N'No change', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (487, 81, 10, 2, 1, 2, N'I smoked more while deployed', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (488, 81, 10, 2, 1, 3, N'I smoked less while deployed', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (489, 81, 10, 2, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (490, 81, 10, 2, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (491, 82, 11, 2, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (492, 82, 11, 2, 1, 2, N'Less than one', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (493, 82, 11, 2, 1, 3, N'1 - 7 days per week', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (494, 82, 11, 2, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (495, 82, 11, 2, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (496, 83, 12, 3, 1, 1, N'Better', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (497, 83, 12, 3, 1, 2, N'Worse', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (498, 83, 12, 3, 1, 3, N'About the same', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (499, 83, 12, 3, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (500, 83, 12, 3, 1, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (501, 84, 12, 3, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (502, 84, 12, 3, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (503, 84, 12, 3, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (504, 84, 12, 3, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (505, 85, 12, 3, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (506, 85, 12, 3, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (507, 85, 12, 3, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (508, 85, 12, 3, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (509, 86, 12, 3, 1, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (510, 86, 12, 3, 1, 2, N'During Deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (511, 86, 12, 3, 1, 3, N'6 Months or less after deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (512, 86, 12, 3, 1, 4, N'More than 6 months later after deployment', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (513, 86, 12, 3, 1, 5, N'Not sure', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (514, 86, 12, 3, 1, 6, N'I do not wish to answer', 0, N'', 16, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (515, 87, 12, 3, 1, 1, N'Not at all concerned', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (516, 87, 12, 3, 1, 2, N'A little concerned', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (517, 87, 12, 3, 1, 3, N'Very concerned', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (518, 87, 12, 3, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (519, 88, 12, 3, 1, 1, N'Lung/Respiratory/Breathing problem', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (520, 88, 12, 3, 1, 2, N'Heart problem', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (521, 88, 12, 3, 1, 3, N'Skin problem', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (522, 88, 12, 3, 1, 4, N'Eye problem', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (523, 88, 12, 3, 1, 5, N'Gastrointestinal (GI) problem', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (524, 88, 12, 3, 1, 6, N'Neurological problem', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (525, 88, 12, 3, 1, 7, N'Immune problem', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (526, 88, 12, 3, 1, 8, N'Effect on children or ability to have children', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (527, 88, 12, 3, 1, 9, N'Cancer', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (528, 88, 12, 3, 1, 10, N'Other problem', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (529, 88, 12, 3, 1, 11, N'I do not wish to answer', 0, N'', 16, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (530, 89, 12, 3, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (531, 89, 12, 3, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (532, 89, 12, 3, 1, 3, N'Not yet, but I would like to talk with a medical professional', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (533, 90, 12, 3, 1, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (534, 90, 12, 3, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (535, 90, 12, 3, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (536, 90, 12, 3, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (537, 91, 12, 3, 1, 1, N'Not at all concerned', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (538, 91, 12, 3, 1, 2, N'A little concerned', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (539, 91, 12, 3, 1, 3, N'Very concerned', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (540, 91, 12, 3, 1, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (541, 92, 12, 3, 1, 1, N'Lung/Respiratory/Breathing', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (542, 92, 12, 3, 1, 2, N'Heart', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (543, 92, 12, 3, 1, 3, N'Skin', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (544, 92, 12, 3, 1, 4, N'Eyes', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (545, 92, 12, 3, 1, 5, N'Effect on children or ability to have children', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (546, 92, 12, 3, 1, 6, N'Cancer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (547, 92, 12, 3, 1, 7, N'Other', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (548, 92, 12, 3, 1, 8, N'I do not wish to answer', 0, N'', 16, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (549, 93, 12, 3, 1, 1, N'<strong>Off</strong> base air pollution during deployment (factories, cars, burning trash, dust)', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (550, 93, 12, 3, 1, 2, N'<strong>On</strong> base air pollution during deployment (burning fuel, burn pits)', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (551, 93, 12, 3, 1, 3, N'Hobbies and non military jobs', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (552, 93, 12, 3, 1, 4, N'Military jobs while I''m not deployed', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (553, 93, 12, 3, 1, 5, N'Smoking (by you or those near you)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (554, 93, 12, 3, 1, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (555, 93, 12, 3, 1, 7, N'Don''t know', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (556, 94, 13, 4, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (557, 94, 13, 4, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (558, 95, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (559, 96, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (560, 96, 13, 4, 1, 2, N'', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (561, 97, 13, 4, 1, 1, N'', 1, N'Enter City Name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (562, 98, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (563, 99, 13, 4, 1, 1, N'', 1, N'Enter Zip code.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (564, 100, 13, 4, 1, 1, N'', 1, N'Enter number of years.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (565, 101, 13, 4, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (566, 101, 13, 4, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (567, 102, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (568, 103, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (569, 103, 13, 4, 1, 2, N'', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (570, 104, 13, 4, 1, 1, N'', 1, N'Enter other city name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (571, 105, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (572, 106, 13, 4, 1, 1, N'', 1, N'Enter Zip code.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (573, 107, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (574, 108, 13, 4, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (575, 108, 13, 4, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (576, 109, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (577, 109, 13, 4, 1, 2, N'', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (578, 110, 13, 4, 1, 1, N'', 1, N'Enter city name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (579, 111, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (580, 112, 13, 4, 1, 1, N'', 1, N'Enter zip code.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (581, 113, 13, 4, 1, 1, N'', 1, N'Enter year moved into this address.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (582, 114, 13, 4, 1, 1, N'', 1, N'Enter year moved out of this address.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (583, 115, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (584, 116, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (585, 116, 13, 4, 1, 2, N'', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (586, 117, 13, 4, 1, 1, N'', 1, N'Enter city name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (587, 118, 13, 4, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (588, 119, 13, 4, 1, 1, N'', 1, N'Enter zip code (5 digit number).', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (589, 120, 13, 4, 1, 1, N'', 1, N'Enter age', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (590, 121, 13, 4, 1, 1, N'', 1, N'Enter age.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (591, 122, 14, 5, 1, 1, N'Working for pay at a job or business', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (592, 122, 14, 5, 1, 2, N'With a job or business but not at work (e.g. a volunteer)', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (593, 122, 14, 5, 1, 3, N'Looking for work', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (594, 122, 14, 5, 1, 4, N'Working, but not for pay, at a family-owned job or business', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (595, 122, 14, 5, 1, 5, N'Not working at a job or business and not looking for work ', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (596, 122, 14, 5, 1, 6, N'I do not wish to answer', 0, N'', 16, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (597, 122, 14, 5, 1, 7, N'Don''t know', 0, N'', 17, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (598, 123, 14, 5, 1, 1, N'Taking care of house or family', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (599, 123, 14, 5, 1, 2, N'Going to school', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (600, 123, 14, 5, 1, 3, N'Retired', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (601, 123, 14, 5, 1, 4, N'On a planned vacation from work', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (602, 123, 14, 5, 1, 5, N'On family or maternity leave', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (603, 123, 14, 5, 1, 6, N'Temporarily unable to work for health reasons', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (604, 123, 14, 5, 1, 7, N'Have job/contract and off-season', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (605, 123, 14, 5, 1, 8, N'On layoff/laid-off from a job', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (606, 123, 14, 5, 1, 9, N'Disabled', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (607, 123, 14, 5, 1, 10, N'Other', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (608, 123, 14, 5, 1, 11, N'I do not wish to answer', 0, N'', 16, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (609, 123, 14, 5, 1, 12, N'Don''t know', 0, N'', 17, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (610, 124, 15, 5, 1, 1, N'Agricultural and fishing/hunting workers', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (611, 124, 15, 5, 1, 2, N'Automotive, aircraft and marine mechanics and service technicians', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (612, 124, 15, 5, 1, 3, N'Construction trade workers, helpers and other construction related workers', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (613, 124, 15, 5, 1, 4, N'Driver/sales workers and truck drivers', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (614, 124, 15, 5, 1, 5, N'Extraction workers (e.g. mining or drilling)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (615, 124, 15, 5, 1, 6, N'Firefighters', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (616, 124, 15, 5, 1, 7, N'Food processing', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (617, 124, 15, 5, 1, 8, N'Forest conservation and logging workers', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (618, 124, 15, 5, 1, 9, N'Police and sheriffs patrol officers', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (619, 124, 15, 5, 1, 10, N'Welding, soldering and brazing', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (620, 124, 15, 5, 1, 11, N'', 1, N'Enter Other occupation.', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (621, 124, 15, 5, 1, 12, N'I do not wish to answer', 0, N'', 16, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (622, 125, 15, 5, 1, 1, N'', 1, N'Enter years in job.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (623, 125, 15, 5, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (624, 125, 15, 5, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (625, 126, 16, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (626, 126, 16, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (627, 126, 16, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (628, 126, 16, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (629, 127, 16, 5, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (630, 128, 16, 5, 1, 1, N'Agricultural and fishing/hunting workers', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (631, 128, 16, 5, 1, 2, N'Automotive, aircraft and marine mechanics and service technicians', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (632, 128, 16, 5, 1, 3, N'Construction trade workers, helpers and other construction related workers', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (633, 128, 16, 5, 1, 4, N'Driver/sales workers and truck drivers', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (634, 128, 16, 5, 1, 5, N'Extraction workers (e.g. mining or drilling)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (635, 128, 16, 5, 1, 6, N'Firefighters', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (636, 128, 16, 5, 1, 7, N'Food processing', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (637, 128, 16, 5, 1, 8, N'Forest conservation and logging workers', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (638, 128, 16, 5, 1, 9, N'Police and sheriffs patrol officers', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (639, 128, 16, 5, 1, 10, N'Welding, soldering and brazing', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (640, 128, 16, 5, 1, 11, N'', 1, N'Enter other occupation.', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (641, 128, 16, 5, 1, 12, N'I do not wish to answer', 0, N'', 16, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (642, 129, 16, 5, 1, 1, N'Animal dander', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (643, 129, 16, 5, 1, 2, N'Wood or sawdust', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (644, 129, 16, 5, 1, 3, N'Metal (aluminum, copper, iron, steel or other types)', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (645, 129, 16, 5, 1, 4, N'Cotton, wool, or other cloth or textile', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (646, 129, 16, 5, 1, 5, N'Asbestos', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (647, 129, 16, 5, 1, 6, N'Plaster', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (648, 129, 16, 5, 1, 7, N'Flour', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (649, 129, 16, 5, 1, 8, N'Cement', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (650, 129, 16, 5, 1, 9, N'Sand or silica', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (651, 129, 16, 5, 1, 10, N'Grain', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (652, 129, 16, 5, 1, 11, N'Coal', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (653, 129, 16, 5, 1, 12, N'Talc', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (654, 129, 16, 5, 1, 13, N'Hay', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (655, 129, 16, 5, 1, 14, N'Fiberglass', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (656, 129, 16, 5, 1, 15, N'Lime', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (657, 129, 16, 5, 1, 16, N'Paper or cardboard', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (658, 129, 16, 5, 1, 17, N'Granite or other rock', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (659, 129, 16, 5, 1, 18, N'Plastic or rubber', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (660, 129, 16, 5, 1, 19, N'Soil or dirt', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (661, 129, 16, 5, 1, 20, N'', 1, N'Enter other dust.', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (662, 129, 16, 5, 1, 21, N'I do not wish to answer', 0, N'', 16, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (663, 130, 16, 5, 1, 1, N'', 1, N'Enter 0 to 99 years.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (664, 130, 16, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (665, 130, 16, 5, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (666, 131, 16, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (667, 131, 16, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (668, 131, 16, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (669, 131, 16, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (670, 132, 17, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (671, 132, 17, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (672, 132, 17, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (673, 132, 17, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (674, 133, 17, 5, 1, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (675, 134, 17, 5, 1, 1, N'Agricultural and fishing/hunting workers', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (676, 134, 17, 5, 1, 2, N'Automotive, aircraft and marine mechanics and service technicians', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (677, 134, 17, 5, 1, 3, N'Construction trade workers, helpers and other construction related workers', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (678, 134, 17, 5, 1, 4, N'Driver/sales workers and truck drivers', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (679, 134, 17, 5, 1, 5, N'Extraction workers (e.g. mining or drilling)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (680, 134, 17, 5, 1, 6, N'Firefighters', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (681, 134, 17, 5, 1, 7, N'Food processing', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (682, 134, 17, 5, 1, 8, N'Forest conservation and logging workers', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (683, 134, 17, 5, 1, 9, N'Police and sheriffs patrol officers', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (684, 134, 17, 5, 1, 10, N'Welding, soldering and brazing', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (685, 134, 17, 5, 1, 11, N'', 1, N'Enter Other occupation.', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (686, 134, 17, 5, 1, 12, N'I do not wish to answer', 0, N'', 16, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (687, 135, 17, 5, 1, 1, N'Cutting oils or mists', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (688, 135, 17, 5, 1, 2, N'Exhaust: primarily diesel engine', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (689, 135, 17, 5, 1, 3, N'Exhaust: primarily gasoline engine', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (690, 135, 17, 5, 1, 4, N'Exhaust: both diesel and gasoline engine', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (691, 135, 17, 5, 1, 5, N'Exhaust: primarily another kind', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (692, 135, 17, 5, 1, 6, N'Fumes from chemicals', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (693, 135, 17, 5, 1, 7, N'Gasoline or other fuel fumes', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (694, 135, 17, 5, 1, 8, N'Paint or lacquers', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (695, 135, 17, 5, 1, 9, N'Pesticides or insecticides', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (696, 135, 17, 5, 1, 10, N'Smoke from burning buildings, fuel oil, refuse, or wood', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (697, 135, 17, 5, 1, 11, N'Solvents', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (698, 135, 17, 5, 1, 12, N'Welding', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (699, 135, 17, 5, 1, 13, N'', 1, N'Enter other gas, smoke, chemical vapor or fume type.', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (700, 135, 17, 5, 1, 14, N'I do not wish to answer', 0, N'', 16, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (701, 135, 17, 5, 1, 15, N'Don''t know', 0, N'', 17, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (702, 136, 17, 5, 1, 1, N'', 1, N'Enter 0 to 99 years.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (703, 136, 17, 5, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (704, 136, 17, 5, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (705, 137, 17, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (706, 137, 17, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (707, 137, 17, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (708, 137, 17, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (709, 138, 18, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (710, 138, 18, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (711, 138, 18, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (712, 138, 18, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (713, 139, 18, 5, 1, 1, N'I did not handle asbestos directly, but asbestos was present on overhead pipes or ceilings, flooring, brakes or other materials.', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (714, 139, 18, 5, 1, 2, N'I did not handle asbestos directly, but I worked in area where asbestos dust was created by others.', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (715, 139, 18, 5, 1, 3, N'I handled asbestos or asbestos containing products directly and created asbestos dust.', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (716, 139, 18, 5, 1, 4, N'I do not wish to answer', 0, N'', 16, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (717, 139, 18, 5, 1, 5, N'Don''t know', 0, N'', 17, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (718, 140, 18, 5, 1, 1, N'', 1, N'Enter 0 to 99 years.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (719, 140, 18, 5, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (720, 140, 18, 5, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (721, 141, 18, 5, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (722, 141, 18, 5, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (723, 141, 18, 5, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (724, 141, 18, 5, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (725, 142, 19, 6, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (726, 142, 19, 6, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (727, 142, 19, 6, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (728, 142, 19, 6, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (729, 143, 19, 6, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (730, 143, 19, 6, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (731, 143, 19, 6, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (732, 143, 19, 6, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (733, 144, 19, 6, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (734, 144, 19, 6, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (735, 144, 19, 6, 1, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (736, 144, 19, 6, 1, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (737, 145, 19, 6, 1, 1, N'Woodworking, including sanding', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (738, 145, 19, 6, 1, 2, N'Welding, brazing or soldering', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (739, 145, 19, 6, 1, 3, N'Metal working, including machining, grinding', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (740, 145, 19, 6, 1, 4, N'Stained glass work', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (741, 145, 19, 6, 1, 5, N'Hobbies utilizing epoxy resin adhesives', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (742, 145, 19, 6, 1, 6, N'Pottery work, including glazing', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (743, 145, 19, 6, 1, 7, N'Indoor swimming and/or indoor ice-skating', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (744, 145, 19, 6, 1, 8, N'None', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (745, 145, 19, 6, 1, 9, N'I do not wish to answer', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (746, 146, 19, 6, 1, 1, N'', 1, N'Enter hours per week (1 through 10 or more).', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (747, 146, 19, 6, 1, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (748, 146, 19, 6, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (749, 147, 20, 7, 1, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (750, 147, 20, 7, 1, 2, N'6 months or less', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (751, 147, 20, 7, 1, 3, N'More than 6 months, but not more than 1 year ago', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (752, 147, 20, 7, 1, 4, N'At least 1 year, but not more than 2 years ago', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (753, 147, 20, 7, 1, 5, N'At least 2 years, but not more than 5 years ago', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (754, 147, 20, 7, 1, 6, N'At least 5 years ago', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (755, 147, 20, 7, 1, 7, N'I do not wish to answer', 0, N'', 16, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (756, 147, 20, 7, 1, 8, N'Don''t know', 0, N'', 17, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (757, 148, 20, 7, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (758, 148, 20, 7, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (759, 148, 20, 7, 1, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (760, 149, 21, 8, 1, 1, N'Email from the VA', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (761, 149, 21, 8, 1, 2, N'VA Web site', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (762, 149, 21, 8, 1, 3, N'Through my health care provider', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (763, 149, 21, 8, 1, 4, N'VA social media (e.g. twitter, facebook)', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (764, 149, 21, 8, 1, 5, N'Letter/U.S. Mail', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (765, 149, 21, 8, 1, 6, N'Through the Department of Defense', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (766, 149, 21, 8, 1, 7, N'Through a Veterans Service Organization', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (767, 149, 21, 8, 1, 8, N'I do not wish to receive any updated information', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (768, 150, 21, 8, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (769, 150, 21, 8, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (770, 150, 21, 8, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (771, 150, 21, 8, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (772, 151, 21, 8, 1, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (773, 151, 21, 8, 1, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (774, 151, 21, 8, 1, 3, N'I do not wish to answer', 0, N'', 16, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (775, 151, 21, 8, 1, 4, N'Don''t know', 0, N'', 17, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1555, 303, 22, 9, 3, 1, N'[deployment history table]', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1556, 304, 23, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1557, 304, 23, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1558, 304, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1559, 304, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1560, 305, 23, 9, 3, 1, N'', 1, N'Enter base name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1561, 305, 23, 9, 3, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1562, 305, 23, 9, 3, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1563, 306, 23, 9, 3, 1, N'', 1, N'Enter base name.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1564, 306, 23, 9, 3, 2, N'I was not at any other bases', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1565, 306, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1566, 306, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1567, 307, 23, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1568, 307, 23, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1569, 307, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1570, 307, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1571, 308, 23, 9, 3, 1, N'U.S. forces or Contractor', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1572, 308, 23, 9, 3, 2, N'Coalition forces', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1573, 308, 23, 9, 3, 3, N'Host nation', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1574, 308, 23, 9, 3, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1575, 308, 23, 9, 3, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1576, 309, 23, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1577, 309, 23, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1578, 309, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1579, 309, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1580, 310, 23, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1581, 310, 23, 9, 3, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1582, 310, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1583, 310, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1584, 311, 23, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1585, 311, 23, 9, 3, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1586, 311, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1587, 311, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1588, 312, 23, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1589, 312, 23, 9, 3, 2, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1590, 312, 23, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1591, 312, 23, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1592, 313, 24, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1593, 313, 24, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1594, 313, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1595, 313, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1596, 314, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1597, 314, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1598, 314, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1599, 314, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1600, 315, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1601, 315, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1602, 315, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1603, 315, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1604, 316, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1605, 316, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1606, 316, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1607, 316, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1608, 317, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1609, 317, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1610, 317, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1611, 317, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1612, 318, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1613, 318, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1614, 318, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1615, 318, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1616, 319, 24, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1617, 319, 24, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1618, 319, 24, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1619, 319, 24, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1620, 320, 25, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1621, 320, 25, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1622, 320, 25, 9, 3, 3, N'Never thought of this', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1623, 320, 25, 9, 3, 4, N'I was not informed or aware of bad air quality', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1624, 320, 25, 9, 3, 5, N'I do not wish to answer', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1625, 320, 25, 9, 3, 6, N'Don''t know', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1626, 321, 25, 9, 3, 1, N'Wore a mask, cravat, or bandana over your mouth or nose', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1627, 321, 25, 9, 3, 2, N'Spent less time outdoors', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1628, 321, 25, 9, 3, 3, N'Did less strenuous activities (i.e. avoided physical training (PT))', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1629, 321, 25, 9, 3, 4, N'Took medication', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1630, 321, 25, 9, 3, 5, N'Closed windows of your sleeping quarters', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1631, 321, 25, 9, 3, 6, N'Spent less time in convoy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1632, 321, 25, 9, 3, 7, N'Canceled outdoor activities', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1633, 321, 25, 9, 3, 8, N'Exercised indoors instead of outdoors', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1634, 321, 25, 9, 3, 9, N'Use or change air filter/air cleaner', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1635, 321, 25, 9, 3, 10, N'Other', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1636, 321, 25, 9, 3, 11, N'I did not (or could not) do anything differently', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1637, 321, 25, 9, 3, 12, N'I do not wish to answer', 0, N'', 16, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1638, 322, 25, 9, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1639, 322, 25, 9, 3, 2, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1640, 322, 25, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1641, 322, 25, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1642, 323, 25, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1643, 323, 25, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1644, 323, 25, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1645, 323, 25, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1646, 324, 25, 9, 3, 2, N'Never', 0, N'', NULL, 0, N'2', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1647, 324, 25, 9, 3, 1, N'', 1, N'Enter 1 to 31 days.', NULL, 0, N'1', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1648, 324, 25, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1649, 324, 25, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1650, 325, 25, 9, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1651, 325, 25, 9, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1652, 325, 25, 9, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1653, 325, 25, 9, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1654, 326, 26, 10, 3, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1655, 326, 26, 10, 3, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1656, 326, 26, 10, 3, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1657, 326, 26, 10, 3, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1658, 326, 26, 10, 3, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1659, 326, 26, 10, 3, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1660, 326, 26, 10, 3, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1661, 326, 26, 10, 3, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1662, 327, 26, 10, 3, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1663, 327, 26, 10, 3, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1664, 327, 26, 10, 3, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1665, 327, 26, 10, 3, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1666, 327, 26, 10, 3, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1667, 327, 26, 10, 3, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1668, 327, 26, 10, 3, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1669, 327, 26, 10, 3, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1670, 328, 26, 10, 3, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1671, 328, 26, 10, 3, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1672, 328, 26, 10, 3, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1673, 328, 26, 10, 3, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1674, 328, 26, 10, 3, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1675, 328, 26, 10, 3, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1676, 328, 26, 10, 3, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1677, 328, 26, 10, 3, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1678, 329, 26, 10, 3, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1679, 329, 26, 10, 3, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1680, 329, 26, 10, 3, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1681, 329, 26, 10, 3, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1682, 329, 26, 10, 3, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1683, 329, 26, 10, 3, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1684, 329, 26, 10, 3, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1685, 329, 26, 10, 3, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1686, 330, 26, 10, 3, 1, N'Not at all difficult', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1687, 330, 26, 10, 3, 2, N'only a little difficult', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1688, 330, 26, 10, 3, 3, N'somewhat difficult', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1689, 330, 26, 10, 3, 4, N'very difficult', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1690, 330, 26, 10, 3, 5, N'can''t do it at all', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1691, 330, 26, 10, 3, 6, N'do not do this activity', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1692, 330, 26, 10, 3, 7, N'I do not wish to answer', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1693, 330, 26, 10, 3, 8, N'Don''t know', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1694, 331, 26, 10, 3, 1, N'Arthritis/rheumatism', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1695, 331, 26, 10, 3, 2, N'Back or neck problem', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1696, 331, 26, 10, 3, 3, N'Benign Tumors, Cysts', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1697, 331, 26, 10, 3, 4, N'Birth defect', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1698, 331, 26, 10, 3, 5, N'Brain injury, (for example, Traumatic Brain Injury/TBI, Intellectual disability)', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1699, 331, 26, 10, 3, 6, N'Cancer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1700, 331, 26, 10, 3, 7, N'Circulation problems (including blood clots)', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1701, 331, 26, 10, 3, 8, N'Depression/anxiety/emotional problem', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1702, 331, 26, 10, 3, 9, N'Diabetes', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1703, 331, 26, 10, 3, 10, N'Epilepsy, seizures', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1704, 331, 26, 10, 3, 11, N'Fibromyalgia, lupus', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1705, 331, 26, 10, 3, 12, N'Fracture, bone/joint injury', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1706, 331, 26, 10, 3, 13, N'Hearing problem', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1707, 331, 26, 10, 3, 14, N'Heart problem', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1708, 331, 26, 10, 3, 15, N'Hernia', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1709, 331, 26, 10, 3, 16, N'Hypertension/high blood pressure', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1710, 331, 26, 10, 3, 17, N'Kidney, bladder or renal problems', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1711, 331, 26, 10, 3, 18, N'Knee problems (not arthritis, not joint injury)', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1712, 331, 26, 10, 3, 19, N'Lung/breathing problem (for example, asthma and emphysema)', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1713, 331, 26, 10, 3, 20, N'Migraine headaches (not just headaches)', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1714, 331, 26, 10, 3, 21, N'Missing limbs (fingers, toes or digits), amputee', 0, N'', NULL, 0, N'21', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1715, 331, 26, 10, 3, 22, N'Multiple Sclerosis (MS), Muscular Dystrophy (MD)', 0, N'', NULL, 0, N'22', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1716, 331, 26, 10, 3, 23, N'Other developmental problem (for example, cerebral palsy)', 0, N'', NULL, 0, N'23', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1717, 331, 26, 10, 3, 24, N'Other injury', 0, N'', NULL, 0, N'24', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1718, 331, 26, 10, 3, 25, N'Other nerve damage, including carpal tunnel syndrome', 0, N'', NULL, 0, N'25', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1719, 331, 26, 10, 3, 26, N'Osteoporosis, tendinitis', 0, N'', NULL, 0, N'26', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1720, 331, 26, 10, 3, 27, N'Parkinson''s disease, other tremors', 0, N'', NULL, 0, N'27', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1721, 331, 26, 10, 3, 28, N'Polio (myelitis), paralysis, para/quadriplegia', 0, N'', NULL, 0, N'28', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1722, 331, 26, 10, 3, 29, N'Senility', 0, N'', NULL, 0, N'29', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1723, 331, 26, 10, 3, 30, N'Stroke problem', 0, N'', NULL, 0, N'30', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1724, 331, 26, 10, 3, 31, N'Thyroid problems, Grave''s disease, gout', 0, N'', NULL, 0, N'31', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1725, 331, 26, 10, 3, 32, N'Ulcer', 0, N'', NULL, 0, N'32', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1726, 331, 26, 10, 3, 33, N'Varicose veins, hemorrhoids', 0, N'', NULL, 0, N'33', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1727, 331, 26, 10, 3, 34, N'Vision/problem seeing', 0, N'', NULL, 0, N'34', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1728, 331, 26, 10, 3, 35, N'Weight problem', 0, N'', NULL, 0, N'35', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1729, 331, 26, 10, 3, 36, N'', 1, N'Other impairment/problem (Specify one).', 18, 0, N'36', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1730, 331, 26, 10, 3, 37, N'I do not wish to answer', 0, N'', 16, 0, N'37', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1731, 331, 26, 10, 3, 38, N'Don''t know/Not sure', 0, N'', 17, 0, N'38', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1732, 332, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1733, 333, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1734, 333, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1735, 333, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1736, 333, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1737, 334, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1738, 334, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1739, 334, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1740, 334, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1741, 335, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1742, 335, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1743, 335, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1744, 335, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1745, 336, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1746, 336, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1747, 336, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1748, 336, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1749, 337, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1750, 337, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1751, 337, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1752, 337, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1753, 338, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1754, 338, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1755, 338, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1756, 338, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1757, 339, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1758, 339, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1759, 339, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1760, 339, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1761, 340, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1762, 340, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1763, 340, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1764, 340, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1765, 341, 27, 10, 3, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1766, 341, 27, 10, 3, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1767, 341, 27, 10, 3, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1768, 341, 27, 10, 3, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1769, 341, 27, 10, 3, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1770, 342, 27, 10, 3, 1, N'Better', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1771, 342, 27, 10, 3, 2, N'Worse', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1772, 342, 27, 10, 3, 3, N'About the same', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1773, 342, 27, 10, 3, 4, N'Not applicable', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1774, 342, 27, 10, 3, 5, N'I do not wish to answer', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1775, 342, 27, 10, 3, 6, N'Don''t know', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1776, 343, 27, 10, 3, 1, N'Cough for more than 3 weeks', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1777, 343, 27, 10, 3, 2, N'Sputum or phlegm production for more than 3 weeks', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1778, 343, 27, 10, 3, 3, N'Wheezing or whistling in the chest', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1779, 343, 27, 10, 3, 4, N'Shortness of breath; breathlessness', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1780, 343, 27, 10, 3, 5, N'Decreased ability to exercise', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1781, 343, 27, 10, 3, 6, N'Hay fever or other respiratory allergy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1782, 343, 27, 10, 3, 7, N'Sore throat, hoarseness, change in voice', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1783, 343, 27, 10, 3, 8, N'Chest pain, chest discomfort or chest tightness', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1784, 343, 27, 10, 3, 9, N'Chronic sinus infection/sinusitis', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1785, 343, 27, 10, 3, 10, N'I do not wish to answer', 0, N'', 16, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1786, 343, 27, 10, 3, 11, N'I do not have these symptoms', 0, N'', 17, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1787, 344, 27, 10, 3, 1, N'Cough for more than 3 weeks', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1788, 344, 27, 10, 3, 2, N'Sputum or phlegm production for more than 3 weeks', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1789, 344, 27, 10, 3, 3, N'Wheezing or whistling in the chest', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1790, 344, 27, 10, 3, 4, N'Shortness of breath; breathlessness', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1791, 344, 27, 10, 3, 5, N'Decreased ability to exercise', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1792, 344, 27, 10, 3, 6, N'Hay fever or other respiratory allergy', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1793, 344, 27, 10, 3, 7, N'Sore throat, hoarseness, change in voice', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1794, 344, 27, 10, 3, 8, N'Chest pain, chest discomfort or chest tightness', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1795, 344, 27, 10, 3, 9, N'Chronic sinus infection/sinusitis', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1796, 344, 27, 10, 3, 10, N'I do not wish to answer', 0, N'', 16, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1797, 344, 27, 10, 3, 11, N'I do not have these symptoms', 0, N'', 17, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1798, 345, 27, 10, 3, 1, N'Not troubled by breathlessness except on strenuous exercise', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1799, 345, 27, 10, 3, 2, N'Short of breath when hurrying on the level or walking up a slight hill', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1800, 345, 27, 10, 3, 3, N'Walking slower than most people on level ground, stop after one mile, or stop after 15 minutes walking at my own pace', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1801, 345, 27, 10, 3, 4, N'Stopping for breath after walking about 100 yards or after a few minutes on level ground', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1802, 345, 27, 10, 3, 5, N'Too breathless to leave the house, or breathless when dressing or undressing', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1803, 345, 27, 10, 3, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1804, 346, 27, 10, 3, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1805, 347, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1806, 347, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1807, 347, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1808, 347, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1809, 348, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1810, 348, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1811, 348, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1812, 348, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1813, 349, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1814, 349, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1815, 349, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1816, 349, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1817, 350, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1818, 350, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1819, 350, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1820, 350, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1821, 351, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1822, 351, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1823, 351, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1824, 351, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1825, 352, 27, 10, 3, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1826, 352, 27, 10, 3, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1827, 352, 27, 10, 3, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1828, 352, 27, 10, 3, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1829, 352, 27, 10, 3, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1830, 353, 27, 10, 3, 1, N'', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1831, 354, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1832, 354, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1833, 354, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1834, 354, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1835, 355, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1836, 355, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1837, 355, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1838, 355, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1839, 356, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1840, 356, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1841, 356, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1842, 356, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1843, 357, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1844, 357, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1845, 357, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1846, 357, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1847, 358, 27, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1848, 358, 27, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1849, 358, 27, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1850, 358, 27, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1851, 359, 27, 10, 3, 1, N'Before deployment', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1852, 359, 27, 10, 3, 2, N'During deployment', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1853, 359, 27, 10, 3, 3, N'After deployment', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1854, 359, 27, 10, 3, 4, N'I do not wish to answer', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1855, 359, 27, 10, 3, 5, N'Don''t know', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1856, 360, 27, 10, 3, 1, N'', 1, N'Enter 1 to 24 hours.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1857, 360, 27, 10, 3, 2, N'I do not wish to answer', 0, N'', 16, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1858, 360, 27, 10, 3, 3, N'Don''t know', 0, N'', 17, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1859, 361, 27, 10, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1860, 361, 27, 10, 3, 2, N'Rarely - less than one night a week', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1861, 361, 27, 10, 3, 3, N'Sometimes - 1 or 2 nights a week', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1862, 361, 27, 10, 3, 4, N'Frequently - 3 to 5 nights a week', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1863, 361, 27, 10, 3, 5, N'Always or almost always - 6 or 7 nights a week', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1864, 361, 27, 10, 3, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1865, 361, 27, 10, 3, 7, N'Don''t know', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1866, 362, 27, 10, 3, 1, N'Never', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1867, 362, 27, 10, 3, 2, N'Rarely - less than one night a week', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1868, 362, 27, 10, 3, 3, N'Sometimes - 1 or 2 nights a week', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1869, 362, 27, 10, 3, 4, N'Frequently - 3 to 5 nights a week', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1870, 362, 27, 10, 3, 5, N'Always or almost always - 6 or 7 nights a week', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1871, 362, 27, 10, 3, 6, N'I do not wish to answer', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1872, 362, 27, 10, 3, 7, N'Don''t know', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1873, 363, 28, 10, 3, 1, N'', 1, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1874, 363, 28, 10, 3, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1875, 363, 28, 10, 3, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1876, 364, 28, 10, 3, 1, N'', 1, N'Enter pounds.', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1877, 364, 28, 10, 3, 2, N'I do not wish to answer', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1878, 364, 28, 10, 3, 3, N'Don''t know', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1879, 365, 29, 10, 3, 1, N'Yes', 0, N'', NULL, 1, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1880, 365, 29, 10, 3, 2, N'No', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1881, 365, 29, 10, 3, 3, N'I do not wish to answer', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1882, 365, 29, 10, 3, 4, N'Don''t know', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1883, 366, 29, 10, 3, 1, N'Bladder', 0, N'', NULL, 0, N'1', NULL, @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1884, 366, 29, 10, 3, 2, N'Blood', 0, N'', NULL, 0, N'2', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1885, 366, 29, 10, 3, 3, N'Bone', 0, N'', NULL, 0, N'3', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1886, 366, 29, 10, 3, 4, N'Brain', 0, N'', NULL, 0, N'4', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1887, 366, 29, 10, 3, 5, N'Breast', 0, N'', NULL, 0, N'5', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1888, 366, 29, 10, 3, 6, N'Cervix', 0, N'', NULL, 0, N'6', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1889, 366, 29, 10, 3, 7, N'Colon', 0, N'', NULL, 0, N'7', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1890, 366, 29, 10, 3, 8, N'Esophagus', 0, N'', NULL, 0, N'8', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1891, 366, 29, 10, 3, 9, N'Gallbladder', 0, N'', NULL, 0, N'9', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1892, 366, 29, 10, 3, 10, N'Kidney', 0, N'', NULL, 0, N'10', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1893, 366, 29, 10, 3, 11, N'Larynx-windpipe', 0, N'', NULL, 0, N'11', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1894, 366, 29, 10, 3, 12, N'Leukemia', 0, N'', NULL, 0, N'12', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1895, 366, 29, 10, 3, 13, N'Liver', 0, N'', NULL, 0, N'13', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1896, 366, 29, 10, 3, 14, N'Lung', 0, N'', NULL, 0, N'14', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1897, 366, 29, 10, 3, 15, N'Lymphoma', 0, N'', NULL, 0, N'15', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1898, 366, 29, 10, 3, 16, N'Melanoma', 0, N'', NULL, 0, N'16', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1899, 366, 29, 10, 3, 17, N'Mouth/tongue/lip', 0, N'', NULL, 0, N'17', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1900, 366, 29, 10, 3, 18, N'Ovary', 0, N'', NULL, 0, N'18', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1901, 366, 29, 10, 3, 19, N'Pancreas', 0, N'', NULL, 0, N'19', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1902, 366, 29, 10, 3, 20, N'Prostate', 0, N'', NULL, 0, N'20', N'', @UserName, @UserName, @Today, @Today)
    INSERT [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID], [STD_FORM_QUESTION_ID], [STD_FORM_SUB_SECTION_ID], [STD_FORM_SECTION_ID], [STD_FORM_ID], [ORDER], [TEXT], [EDITABLE], [HELP], [STD_CONCEPT_ID], [CLINICAL_RELEVANT_FLAG], [BRP_FORM_ANSWER_ID], [BRP_FORM_QUESTION_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1903, 366, 29, 10, 3, 21, N'Rectum', 0, N'', NULL, 0, N'21', N'', @UserName